use crate::window::Window;

#[cfg(windows)]
pub fn run(window: Box<dyn Window>) {
    let attributes = window.attributes();
    let manifest = window.manifest();
    window.show(attributes,manifest);
}

#[cfg(unix)]
pub fn run(window: Box<dyn Window>) {
    let attributes = window.attributes();
    let manifest = window.manifest();
    // Initialize GTK
    if gtk::init().is_err() {
        println!("Failed to initialize GTK.");
        return;
    }
    window.show(attributes,manifest);
}