// Dialog Styles
#[cfg(windows)]
pub const DIALOGSTYLE_NONE: windows::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE = windows::Win32::UI::WindowsAndMessaging::MB_ICONMASK;
#[cfg(windows)]
pub const DIALOGSTYLE_INFO: windows::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE = windows::Win32::UI::WindowsAndMessaging::MB_ICONINFORMATION;
#[cfg(windows)]
pub const DIALOGSTYLE_QUESTION: windows::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE = windows::Win32::UI::WindowsAndMessaging::MB_ICONQUESTION;
#[cfg(windows)]
pub const DIALOGSTYLE_WARNING: windows::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE = windows::Win32::UI::WindowsAndMessaging::MB_ICONWARNING;
#[cfg(windows)]
pub const DIALOGSTYLE_ERROR: windows::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE = windows::Win32::UI::WindowsAndMessaging::MB_ICONERROR;

#[cfg(unix)]
pub const DIALOGSTYLE_NONE: gtk::MessageType = gtk::MessageType::Other;
#[cfg(unix)]
pub const DIALOGSTYLE_INFO: gtk::MessageType = gtk::MessageType::Info;
#[cfg(unix)]
pub const DIALOGSTYLE_QUESTION: gtk::MessageType = gtk::MessageType::Question;
#[cfg(unix)]
pub const DIALOGSTYLE_WARNING: gtk::MessageType = gtk::MessageType::Warning;
#[cfg(unix)]
pub const DIALOGSTYLE_ERROR: gtk::MessageType = gtk::MessageType::Error;

// Button Styles
#[cfg(windows)]
pub const BUTTONSTYLE_OK:windows::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE = windows::Win32::UI::WindowsAndMessaging::MB_OK;
#[cfg(windows)]
pub const BUTTONSTYLE_OKCANCEL:windows::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE = windows::Win32::UI::WindowsAndMessaging::MB_OKCANCEL;
#[cfg(windows)]
pub const BUTTONSTYLE_YESNO:windows::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE = windows::Win32::UI::WindowsAndMessaging::MB_YESNO;
#[cfg(windows)]
pub const BUTTONSTYLE_YESNOCANCEL:windows::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE = windows::Win32::UI::WindowsAndMessaging::MB_YESNOCANCEL;

#[cfg(unix)]
pub const BUTTONSTYLE_OK:gtk::ButtonsType = gtk::ButtonsType::Ok;
#[cfg(unix)]
pub const BUTTONSTYLE_OKCANCEL:gtk::ButtonsType = gtk::ButtonsType::OkCancel;
#[cfg(unix)]
pub const BUTTONSTYLE_YESNO:gtk::ButtonsType = gtk::ButtonsType::YesNo;
#[cfg(unix)]
pub const BUTTONSTYLE_YESNOCANCEL:gtk::ButtonsType = gtk::ButtonsType::YesNo|gtk::ButtonsType::Cancel;

// MessageBox Results
#[cfg(windows)]
pub const RESULT_OK:windows::Win32::UI::WindowsAndMessaging::MESSAGEBOX_RESULT = windows::Win32::UI::WindowsAndMessaging::MESSAGEBOX_RESULT(1);
#[cfg(windows)]
pub const RESULT_CANCEL:windows::Win32::UI::WindowsAndMessaging::MESSAGEBOX_RESULT = windows::Win32::UI::WindowsAndMessaging::MESSAGEBOX_RESULT(2);
#[cfg(windows)]
pub const RESULT_YES:windows::Win32::UI::WindowsAndMessaging::MESSAGEBOX_RESULT = windows::Win32::UI::WindowsAndMessaging::MESSAGEBOX_RESULT(6);
#[cfg(windows)]
pub const RESULT_NO:windows::Win32::UI::WindowsAndMessaging::MESSAGEBOX_RESULT = windows::Win32::UI::WindowsAndMessaging::MESSAGEBOX_RESULT(7);

#[cfg(unix)]
pub const RESULT_OK:gtk::ResponseType = gtk::ResponseType::Ok;
#[cfg(unix)]
pub const RESULT_CANCEL:gtk::ResponseType = gtk::ResponseType::Cancel;
#[cfg(unix)]
pub const RESULT_YES:gtk::ResponseType = gtk::ResponseType::Yes;
#[cfg(unix)]
pub const RESULT_NO:gtk::ResponseType = gtk::ResponseType::No;

// Window Styles
pub const WINDOWSTYLE_NORMAL: windows::Win32::UI::WindowsAndMessaging::WINDOW_STYLE = windows::Win32::UI::WindowsAndMessaging::WS_OVERLAPPEDWINDOW;
pub const WINDOWSTYLE_CAPTION: windows::Win32::UI::WindowsAndMessaging::WINDOW_STYLE = windows::Win32::UI::WindowsAndMessaging::WS_CAPTION;
pub const WINDOWSTYLE_BORDER: windows::Win32::UI::WindowsAndMessaging::WINDOW_STYLE = windows::Win32::UI::WindowsAndMessaging::WS_BORDER;
pub const WINDOWSTYLE_SYSMENU: windows::Win32::UI::WindowsAndMessaging::WINDOW_STYLE = windows::Win32::UI::WindowsAndMessaging::WS_SYSMENU;
pub const WINDOWSTYLE_MAXIMIZED: windows::Win32::UI::WindowsAndMessaging::WINDOW_STYLE = windows::Win32::UI::WindowsAndMessaging::WS_MAXIMIZE;
pub const WINDOWSTYLE_MINIMIZED: windows::Win32::UI::WindowsAndMessaging::WINDOW_STYLE = windows::Win32::UI::WindowsAndMessaging::WS_MINIMIZE;