use windows::Win32::UI::WindowsAndMessaging::*;

#[cfg(windows)]
pub struct MessageBox {
    pub title: String,
    pub message: String,
    pub style: MESSAGEBOX_STYLE,
    pub button_style: MESSAGEBOX_STYLE
}

#[cfg(unix)]
pub struct MessageBox {
    pub title: String,
    pub message: String,
    pub style: gtk::MessageType,
    pub button_style: gtk::ButtonsType
}

impl MessageBox {
    pub fn new(title: String, message: String, style: MESSAGEBOX_STYLE, button_style: MESSAGEBOX_STYLE) -> Self {
        Self {
            title,
            message,
            style,
            button_style
        }
    }

    pub fn show(self) -> MESSAGEBOX_RESULT {
        unsafe {
            let result = MessageBoxA(None, self.message, self.title, self.style|self.button_style);
            result
        }
    }
}

#[cfg(unix)]
impl MessageBox {
    pub fn new(title: String, message: String, style: gtk::MessageType, button_style: gtk::ButtonsType) -> Self {
        Self {
            title,
            message,
            style,
            button_style
        }
    }

    pub fn show(self) -> gtk::ResponseType {
        use gtk::prelude::*;
        gtk::init().expect("Failed to initialize GTK.");

        let window = gtk::Window::new(gtk::WindowType::Toplevel);

        window.set_title(&*self.title);
        let window_ = window.clone();
        let dialog = gtk::MessageDialog::new(
            Some(&window_),
            gtk::DialogFlags::empty(),
            self.style,
            self.button_style,
            &self.message
        );
        let result = dialog.run();
        result
    }
}