# NXUI - Native X UI
[![Rust Deploy](https://github.com/LatteSyobon/nxui/actions/workflows/rust.yml/badge.svg)](https://github.com/LatteSyobon/nxui/actions/workflows/rust.yml)  
A cross-platform GUI toolkit in Rust

NXUI is a GUI toolkit that calls OS native APIs as much as possible to achieve fast operation.  
It also aims to make it easy to customize windows (e.g. Client Side Decoration).

Click [here](examples/README.md) for samples.

# How cross-platform is it?
Stable: All functions of nxui are available.  
Normal: You can use the nxui functions reasonably well.  
Beta: Inability to use nxui functions at all or only a little
|        |  Windows  | MacOS | Linux |
| ----   | --------- | ----- |-------|
| Status |  Stable   | Beta  | Stable|
| Version| 0.0.1 ~ Latest Version | N/A | 0.0.5 ~ Latest Version

# Learn more about goals.
If you'd like to know a little more about the goals of NXUI, take a look at this section.  
If you don't want to see that, jump to the next section from [here](https://github.com/LatteSyobon/nxui#How%20to%20Build).    
As mentioned above, NXUI is a GUI toolkit made by Rust that calls the native API as much as possible and aims for fast operation.  
It also features cross-platform operation.  
Cross-platform here means that if you just want to display a window or something without doing any special processing, you can use this library alone (you don't need to change the GUI behavior using #cfg attributes, etc.).

For this purpose, we use the #cfg attribute in the library part to optimize the GUI processing for the OS. Also, the effect of this is that you don't really need to use the #cfg attribute in the part that uses the library.  
You did it!
:blush:

# Crates

## NXUI-Core
Core part of the XUI GUI toolkit  
![Crates.io](https://img.shields.io/crates/v/nxui)
![Crates.io](https://img.shields.io/crates/d/nxui)
![Crates.io](https://img.shields.io/crates/l/nxui)

# How to Build
Basically, you should be able to build it in the following way
```
git clone https://github.com/LatteSyobon/nxui
cd nxui
cargo build
```
However, on Linux, you need to have downloaded gtk3  
If you have any problems with the build, please report them [here](https://github.com/LatteSyobon/nxui/issues).

# Note
Currently, there is a problem with garbled text in the debug build when displaying dialogs.  
This problem can be solved by making it a release build.

# Thanks
## Libraries used
* windows-rs
* gtk-rs

# LICENSE
NXUI is licensed under the [MIT License](https://opensource.org/licenses/MIT)
