use windows_sys::Win32::Foundation::PSTR;
use windows_sys::Win32::UI::WindowsAndMessaging::HICON;

pub struct WindowManifest {
    pub class: PSTR,
    pub application_id: String,
    pub icon: HICON,
}

impl WindowManifest {
    pub fn new(classname: String, application_id: String, icon: HICON) -> Self {
        let class: PSTR = classname.as_ptr() as _;
        Self {
            class,
            application_id,
            icon,
        }
    }
}

impl Default for WindowManifest {
    fn default() -> Self {
        let class: PSTR = "window".as_ptr() as _;
        Self {
            class,
            application_id: "org.example.demo".to_string(),
            icon: HICON::default(),
        }
    }
}
