use windows_sys::Win32::Foundation::{HINSTANCE, PSTR, PWSTR};
use windows_sys::Win32::UI::WindowsAndMessaging::{LoadImageW, HICON, IMAGE_ICON, LR_LOADFROMFILE};

pub struct Icon {}

impl Icon {
    pub unsafe fn new(icon_path: String) -> HICON {
        let mut text = icon_path.encode_utf16().collect::<Vec<u16>>();
        let pwstr = PWSTR::from(text.as_mut_ptr());
        let hIcon = LoadImageW(
            HINSTANCE::default(),
            pwstr,
            IMAGE_ICON,
            0,
            0,
            LR_LOADFROMFILE,
        );
        hIcon
    }
}

impl Default for Icon {
    fn default() -> Self {
        Self {}
    }
}
