#[cfg(unix)]
use gtk::glib::translate::Ptr;
use windows_sys::Win32::Foundation::PSTR;

#[cfg(windows)]
#[derive(Clone)]
#[deprecated(since="0.5.2", note="please use `WindowManifest` instead")]
pub struct WindowClass {
    pub class: PSTR,
    pub application_id: String,
}

#[cfg(unix)]
#[derive(Clone)]
#[deprecated(since="0.5.2", note="please use `WindowManifest` instead")]
pub struct WindowClass {
    pub class: String,
    pub application_id: String,
}

#[cfg(windows)]
#[deprecated(since="0.5.2", note="please use `WindowManifest` instead")]
impl WindowClass {
    pub fn new(classname: String, application_id: String) -> Self {
        let class: PSTR = classname.as_ptr() as _;
        Self {
            class,
            application_id,
        }
    }

    pub fn get_class(self) -> PSTR {
        self.class
    }

    pub fn get_application_id(self) -> String {
        self.application_id
    }
}

// *-ptr window.rs 178 class

#[cfg(unix)]
#[deprecated(since="0.5.2", note="please use `WindowManifest` instead")]
impl WindowClass {
    pub fn new(class: String, application_id: String) -> Self {
        Self {
            class,
            application_id,
        }
    }
// method not found in String
    pub unsafe fn get_class(self) -> String {
        self.class
    }
// expected &str
    pub fn get_application_id(self) -> String {
        self.application_id
    }
}
