#[cfg(unix)]
use gtk::glib::translate::Ptr;
use windows_sys::Win32::Foundation::PSTR;

#[cfg(windows)]
#[derive(Clone)]
pub struct WindowClass {
    class: PSTR,
    application_id: String,
}

#[cfg(unix)]
#[derive(Clone)]
pub struct WindowClass {
    class: String,
    application_id: String,
}

#[cfg(windows)]
impl WindowClass {
    pub fn new(classname: String, application_id: String) -> Self {
        let class: PSTR = classname.as_ptr() as _;
        Self {
            class,
            application_id,
        }
    }

    pub fn get_class(self) -> PSTR {
        self.class
    }

    pub fn get_application_id(self) -> String {
        self.application_id
    }
}

// *-ptr window.rs 178 class

#[cfg(unix)]
impl WindowClass {
    pub fn new(class: String, application_id: String) -> Self {
        Self {
            class,
            application_id,
        }
    }

    pub fn get_class(self) -> String {
        *-self.class.to()
    }

    pub fn get_application_id(self) -> String {
        self.application_id.asbytes()
    }
}
