use crate::messagebox::MessageBox;
use crate::window::{Window, WindowAttributes};
use crate::windowclass::WindowClass;
use crate::Event::*;
use crate::NativesAndMessaging::*;

pub struct DemoWindow {}

impl DemoWindow {
    pub fn new() -> Self {
        Self {}
    }
}

#[cfg(windows)]
impl Window for DemoWindow {
    fn attributes(&self) -> WindowAttributes {
        let class = WindowClass::new("window".to_string(), "org.example.demo".to_string());
        let attributes = WindowAttributes::new(
            class,
            WINDOWSTYLE_OVERLAPPED,
            "Hello world".to_string(),
            1280,
            750,
            500,
            500,
        );
        attributes
    }

    fn exit(&self) {
        let dialog = MessageBox::new(
            "The application has been terminated.".to_string(),
            "The application has been terminated.".to_string(),
        );
        match dialog.show(BUTTONSTYLE_YESNO, DIALOGSTYLE_INFO, DIALOGHINT_MODAL) {
            YES => {
                println!("The application has been terminated.")
            }

            NO => {
                let dialog = MessageBox::new(
                    "The application is finished, okay?".to_string(),
                    "The application is finished, okay?".to_string(),
                );
                dialog.show(BUTTONSTYLE_OK, DIALOGSTYLE_WARN, DIALOGHINT_MODAL);
            }

            _ => {}
        }
    }
}

#[cfg(unix)]
impl Window for DemoWindow {
    fn attributes(&self) -> WindowAttributes {
        let class = WindowClass::new("window".to_string(), "org.example.demo".to_string());
        let attributes = WindowAttributes::new(
            class,
            WINDOWSTYLE_OVERLAPPED,
            "Hello world".to_string(),
            1280,
            750,
            500,
            500,
        );
        attributes
    }

    fn exit(&self) {
        let dialog = MessageBox::new(
            "The application has been terminated.".to_string(),
            "The application has been terminated.".to_string(),
        );
        match dialog.show(BUTTONSTYLE_YESNO, DIALOGSTYLE_INFO, DIALOGHINT_MODAL) {
            YES => {
                println!("The application has been terminated.")
            }

            NO => {
                let dialog = MessageBox::new(
                    "The application is finished, okay?".to_string(),
                    "The application is finished, okay?".to_string(),
                );
                dialog.show(BUTTONSTYLE_OK, DIALOGSTYLE_WARN, DIALOGHINT_MODAL);
            }

            _ => {}
        }
    }
}
