use windows_sys::Win32::Foundation::PSTR;

#[cfg(windows)]
#[derive(Clone, Debug)]
pub struct WindowClass {
    class: PSTR,
    application_id: String,
}

#[cfg(unix)]
#[derive(Clone, Debug)]
pub struct WindowClass {
    class: String,
    application_id: String,
}

#[cfg(windows)]
impl WindowClass {
    pub fn new(classname: String, application_id: String) -> Self {
        let class: PSTR = classname.as_ptr() as _;
        Self {
            class,
            application_id,
        }
    }

    pub fn get_class(self) -> PSTR {
        self.class
    }

    pub fn get_application_id(self) -> String {
        self.application_id
    }
}

#[cfg(unix)]
impl WindowClass {
    pub fn new(class: String, application_id: String) -> Self {
        Self {
            class,
            application_id,
        }
    }

    pub fn get_class(self) -> String {
        self.class
    }

    pub fn get_application_id(self) -> String {
        self.application_id
    }
}
