use crate::Event;
use windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE;
#[cfg(unix)]
use gtk::*;

#[cfg(windows)]
pub struct MessageBox {
    pub title: String,
    pub message: String,
}

#[cfg(unix)]
pub struct MessageBox {
    pub title: String,
    pub message: String,
}

#[cfg(windows)]
impl MessageBox {
    ///
    /// Create a new dialog
    ///
    pub fn new(title: String, message: String) -> Self {
        Self { title, message }
    }

    ///
    /// Returns the title
    ///
    pub fn get_title(&self) -> &str {
        &self.title
    }

    ///
    /// Returns the message
    ///
    pub fn get_message(&self) -> &str {
        &self.message
    }

    /// Display the dialog
    ///
    /// # Examples
    ///
    ///There are several types of DIALOGSTYLE for the second argument
    /// - DIALOGSTYLE_NONE
    /// - DIALOGSTYLE_INFO
    /// - DIALOGSTYLE_QUESTION
    /// - DIALOGSTYLE_EXCLAMATION
    /// - DIALOGSTYLE_ERROR
    ///```
    /// use nxui::messagebox;
    /// use nxui::NativesAndMessaging::*;
    ///
    /// fn main() {
    ///     let msg_box = messagebox::MessageBox { title: "This is a test".to_string().parse().unwrap(), message: "Hello World".to_string().parse().unwrap() };
    ///     msg_box.show(BUTTONSTYLE_OK,DIALOGSTYLE_INFO,DIALOGHINT_MODAL);
    /// }
    /// ```

    pub fn show(
        &self,
        button_style: MESSAGEBOX_STYLE,
        dialog_style: MESSAGEBOX_STYLE,
        dialog_hint: u64,
    ) -> i32 {
        use windows_sys::{
            Win32::Foundation::*, Win32::System::Threading::*, Win32::UI::WindowsAndMessaging::*,
        };
        unsafe {
            let event = CreateEventW(std::ptr::null(), 1, 0, std::ptr::null());
            SetEvent(event);
            println!("{}", event);
            WaitForSingleObject(event, 0);
            CloseHandle(event);
            let event_handler = Event::DialogEventHandler::new();
            let event = event_handler.set_event(MessageBoxA(
                dialog_hint.try_into().unwrap(),
                self.message.as_ptr(),
                self.title.as_ptr(),
                dialog_style | button_style,
            ));
            println!("{}", event);
            return event;
        }
    }
}

#[cfg(unix)]
impl MessageBox {
    ///
    /// Create a new dialog
    ///
    pub fn new(title: String, message: String) -> Self {
        Self { title, message }
    }

    ///
    /// Returns the title
    ///
    pub fn get_title(&self) -> &str {
        &self.title
    }

    ///
    /// Returns the message
    ///
    pub fn get_message(&self) -> &str {
        &self.message
    }

    /// Display the dialog
    ///
    /// # Examples
    ///
    ///There are several types of DIALOGSTYLE for the second argument
    /// - DIALOGSTYLE_NONE
    /// - DIALOGSTYLE_INFO
    /// - DIALOGSTYLE_QUESTION
    /// - DIALOGSTYLE_EXCLAMATION
    /// - DIALOGSTYLE_ERROR
    ///```
    /// use nxui::messagebox;
    /// use nxui::NativesAndMessaging::*;
    ///
    /// fn main() {
    ///     let msg_box = messagebox::MessageBox { title: "This is a test".to_string().parse().unwrap(), message: "Hello World".to_string().parse().unwrap() };
    ///     msg_box.show(BUTTONSTYLE_OK,DIALOGSTYLE_INFO,DIALOGHINT_MODAL);
    /// }
    /// ```
    pub fn show(
        &self,
        button_style: ButtonsType,
        dialog_style: MessageType,
        dialog_hints: DialogFlags,
    ) -> DialogEventType {
        use gtk::prelude::*;
        use gtk::Window;
        use crate::Event::*;
        use gtk::{ButtonsType, DialogFlags, MessageType};
        gtk::init();
        let dialog = gtk::MessageDialog::new(
            Some(&gtk::Window::new(gtk::WindowType::Toplevel)),
            dialog_hints,
            dialog_style,
            button_style,
            &self.message,
        );
        let event_handler = Event::DialogEventHandler::new();
        let event = event_handler.set_event(dialog.run());
        println!("{}", event);
        unsafe {
            dialog.destroy();
        }
        return event;
    }
}
