#[cfg(linux)]
use gtk::gdk::WindowTypeHint;
#[cfg(linux)]
use gtk::prelude::*;
#[cfg(windows)]
use windows_sys::Win32::UI::WindowsAndMessaging::*;

// Button Styles

#[cfg(windows)]
pub const BUTTONSTYLE_HELP: MESSAGEBOX_STYLE = 16384u32;
#[cfg(linux)]
pub const BUTTONSTYLE_HELP: ButtonsType = gtk::ButtonsType::Ok;

#[cfg(windows)]
pub const BUTTONSTYLE_OK: MESSAGEBOX_STYLE = 0u32;
#[cfg(linux)]
pub const BUTTONSTYLE_OK: ButtonsType = gtk::ButtonsType::Ok;

#[cfg(windows)]
pub const BUTTONSTYLE_OKCANCEL: MESSAGEBOX_STYLE = 1u32;
#[cfg(linux)]
pub const BUTTONSTYLE_OKCANCEL: ButtonsType = gtk::ButtonsType::OkCancel;

#[cfg(windows)]
pub const BUTTONSTYLE_CANCEL: MESSAGEBOX_STYLE = 1u32;
#[cfg(linux)]
pub const BUTTONSTYLE_CANCEL: ButtonsType = gtk::ButtonsType::Cancel;

#[cfg(windows)]
pub const BUTTONSTYLE_CLOSE: MESSAGEBOX_STYLE = 1u32;
#[cfg(linux)]
pub const BUTTONSTYLE_CLOSE: ButtonsType = gtk::ButtonsType::Close;

#[cfg(windows)]
pub const BUTTONSTYLE_NONE: MESSAGEBOX_STYLE = 0;
#[cfg(linux)]
pub const BUTTONSTYLE_NONE: ButtonsType = gtk::ButtonsType::None;

#[cfg(windows)]
pub const BUTTONSTYLE_YESNO: MESSAGEBOX_STYLE = 4u32;
#[cfg(linux)]
pub const BUTTONSTYLE_YESNO: ButtonsType = gtk::ButtonsType::YesNo;

// Dialog Styles

#[cfg(windows)]
pub const DIALOGSTYLE_NONE: MESSAGEBOX_STYLE = 0;
#[cfg(linux)]
pub const DIALOGSTYLE_NONE: MessageType = gtk::MessageType::Other;

#[cfg(windows)]
pub const DIALOGSTYLE_INFO: MESSAGEBOX_STYLE = 64u32;
#[cfg(linux)]
pub const DIALOGSTYLE_INFO: MessageType = gtk::MessageType::Info;

#[cfg(windows)]
pub const DIALOGSTYLE_QUESTION: MESSAGEBOX_STYLE = 32u32;
#[cfg(linux)]
pub const DIALOGSTYLE_NONE: MessageType = gtk::MessageType::Question;

#[cfg(windows)]
pub const DIALOGSTYLE_WARN: MESSAGEBOX_STYLE = 48u32;
#[cfg(linux)]
pub const DIALOGSTYLE_WARN: MessageType = gtk::MessageType::Warning;

#[cfg(windows)]
pub const DIALOGSTYLE_ERROR: MESSAGEBOX_STYLE = 16u32;
#[cfg(linux)]
pub const DIALOGSTYLE_ERROR: MessageType = gtk::MessageType::ERROR;

// Dialog hints

#[cfg(windows)]
pub const DIALOGHINT_MODAL: u64 = 0;
#[cfg(linux)]
pub const DIALOGHINT_MODAL: gtk::DialogFlags = gtk::DialogFlags::MODAL;

// Window Styles

#[cfg(windows)]
pub const WINDOWSTYLE_OVERLAPPED: WINDOW_STYLE = 13565952u32;
#[cfg(linux)]
pub const WINDOWSTYLE_OVERLAPPED: WindowTypeHint = gtk::WindowType::Toplevel;

#[cfg(windows)]
pub const WINDOWSTYLE_POPUP: WINDOW_STYLE = 2147483648u32;
#[cfg(linux)]
pub const WINDOWSTYLE_POPUP: WindowTypeHint = gtk::gdk::WindowTypeHint::PopupMenu;

#[cfg(windows)]
pub const WINDOWSTYLE_CHILD: WINDOW_STYLE = 1073741824u32;
#[cfg(linux)]
pub const WINDOWSTYLE_CHILD: WindowTypeHint = gtk::gdk::WindowTypeHint::Desktop;

#[cfg(windows)]
pub const WINDOWSTYLE_MINIMIZE: WINDOW_STYLE = 536870912u32;
#[cfg(linux)]
pub const WINDOWSTYLE_MINIMIZE: WindowTypeHint = gtk::gdk::WindowTypeHint::Desktop;

#[cfg(windows)]
pub const WINDOWSTYLE_DISABLED: WINDOW_STYLE = 134217728u32;
#[cfg(linux)]
pub const WINDOWSTYLE_DISABLED: WindowTypeHint = gtk::gdk::WindowTypeHint::Desktop;

#[cfg(windows)]
pub const WINDOWSTYLE_MAXIMIZE: WINDOW_STYLE = 16777216u32;
#[cfg(linux)]
pub const WINDOWSTYLE_MAXIMIZE: WindowTypeHint = gtk::gdk::WindowTypeHint::Desktop;

#[cfg(windows)]
pub const WINDOWSTYLE_CAPTION: WINDOW_STYLE = 12582912u32;
#[cfg(linux)]
pub const WINDOWSTYLE_CAPTION: WindowTypeHint = gtk::gdk::WindowTypeHint::Normal;

#[cfg(windows)]
pub const WINDOWSTYLE_SYSMENU: WINDOW_STYLE = 524288u32;
#[cfg(linux)]
pub const WINDOWSTYLE_SYSMENU: WindowTypeHint = gtk::gdk::WindowTypeHint::Dialog;

#[cfg(windows)]
pub const WINDOWSTYLE_VSCROLL: WINDOW_STYLE = 2097152u32;
#[cfg(linux)]
pub const WINDOWSTYLE_VSCROLL: WindowTypeHint = gtk::gdk::WindowTypeHint::Desktop;

#[cfg(windows)]
pub const WINDOWSTYLE_SIZEBOX: WINDOW_STYLE = 262144u32;
#[cfg(linux)]
pub const WINDOWSTYLE_SIZEBOX: WindowTypeHint = gtk::gdk::WindowTypeHint::Desktop;
