#[cfg(windows)]
pub struct DialogEventHandler {
    event: DialogEventType,
}

#[cfg(linux)]
struct DialogEventHandler {
    event: DialogEventType,
}

#[cfg(windows)]
impl DialogEventHandler {
    pub fn new() -> Self {
        Self { event: NONE }
    }

    pub fn set_event(&self, event: i32) -> DialogEventType {
        match event {
            6 => YES,

            7 => NO,

            1 => OK,

            2 => CANCEL,

            0 => NONE,

            2 => CLOSE,

            _ => NONE,
        }
    }
}

#[cfg(linux)]
impl DialogEventHandler {
    pub fn new() -> Self {
        Self { event: NONE }
    }

    pub fn set_event(&self, event: gtk::ResponseType) -> DialogEventType {
        match event {
            gtk::ResponseType::Yes => YES,

            gtk::ResponseType::No => NO,

            gtk::ResponseType::Ok => OK,

            gtk::ResponseType::Cancel => CANCEL,

            gtk::ResponseType::None => NONE,

            gtk::ResponseType::Close => CLOSE,

            _ => NONE,
        }
    }
}

pub type DialogEventType = i32;

pub const YES: DialogEventType = 6;
pub const NO: DialogEventType = 7;
pub const OK: DialogEventType = 1;
pub const CANCEL: DialogEventType = 2;
pub const CLOSE: DialogEventType = 2;
pub const NONE: DialogEventType = 0;
