use windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE;

#[cfg(windows)]
pub struct MessageBox {
    pub title: String,
    pub message: String,
}

#[cfg(linux)]
pub struct MessageBox {
    pub title: String,
    pub message: String,
}

#[cfg(windows)]
impl MessageBox {
    ///
    /// Create a new dialog
    ///
    pub fn new(title: String, message: String) -> Self {
        Self { title, message }
    }

    ///
    /// Returns the title
    ///
    pub fn get_title(&self) -> &str {
        &self.title
    }

    ///
    /// Returns the message
    ///
    pub fn get_message(&self) -> &str {
        &self.message
    }

    /// Display the dialog
    ///
    /// # Examples
    ///
    ///There are several types of DIALOGSTYLE for the second argument
    /// - DIALOGSTYLE_NONE
    /// - DIALOGSTYLE_INFO
    /// - DIALOGSTYLE_QUESTION
    /// - DIALOGSTYLE_EXCLAMATION
    /// - DIALOGSTYLE_ERROR
    ///```
    /// use nxui::messagebox;
    /// use nxui::NativesAndMessaging::*;
    ///
    /// fn main() {
    ///     let msg_box = messagebox::MessageBox { title: "This is a test".to_string().parse().unwrap(), message: "Hello World".to_string().parse().unwrap() };
    ///     msg_box.show(BUTTONSTYLE_OK,DIALOGSTYLE_INFO,DIALOGHINT_MODAL);
    /// }
    /// ```
    #[cfg(windows)]
    pub fn show(
        &self,
        button_style: MESSAGEBOX_STYLE,
        dialog_style: MESSAGEBOX_STYLE,
        dialog_hint: u64,
    ) -> i32{
        use windows_sys::{
            Win32::Foundation::*, Win32::System::Threading::*, Win32::UI::WindowsAndMessaging::*,
        };
        unsafe {
            let event = CreateEventW(std::ptr::null(), 1, 0, std::ptr::null());
            SetEvent(event);
            println!("{}",event);
            WaitForSingleObject(event, 0);
            CloseHandle(event);
            let result = MessageBoxA(
                dialog_hint.try_into().unwrap(),
                self.message.as_ptr(),
                self.title.as_ptr(),
                dialog_style | button_style,
            );
            println!("{}",result);
            return result;
        }
    }
}

#[cfg(linux)]
impl MessageBox {
    ///
    /// Create a new dialog
    ///
    pub fn new(title: String, message: String) -> Self {
        Self { title, message }
    }

    ///
    /// Returns the title
    ///
    pub fn get_title(&self) -> &str {
        &self.title
    }

    ///
    /// Returns the message
    ///
    pub fn get_message(&self) -> &str {
        &self.message
    }

    /// Display the dialog
    ///
    /// # Examples
    ///
    ///There are several types of DIALOGSTYLE for the second argument
    /// - DIALOGSTYLE_NONE
    /// - DIALOGSTYLE_INFO
    /// - DIALOGSTYLE_QUESTION
    /// - DIALOGSTYLE_EXCLAMATION
    /// - DIALOGSTYLE_ERROR
    ///```
    /// use nxui::messagebox;
    /// use nxui::NativesAndMessaging::*;
    ///
    /// fn main() {
    ///     let msg_box = messagebox::MessageBox { title: "This is a test".to_string().parse().unwrap(), message: "Hello World".to_string().parse().unwrap() };
    ///     msg_box.show(BUTTONSTYLE_OK,DIALOGSTYLE_INFO,DIALOGHINT_MODAL);
    /// }
    /// ```
    pub fn show(
        &self,
        button_style: ButtonsType,
        dialog_style: MessageType,
        dialog_hint: DialogFlags,
    ) {
        use gtk::prelude::*;
        let dialog = gtk::MessageDialog::new(
            Some(&window_),
            window_style,
            dialog_style,
            button_type,
            &message,
        );
        dialog.run();
        dialog.destroy();
    }
}
