use crate::io::storage::Storage;
use crate::natives_and_messaging::*;
use crate::widget::menu::Menu;
use crate::widget::menubar::MenuBar;
use crate::widget::menuitem::MenuItem;
use crate::window::{Application, Frame, Attributes};

pub struct DemoWindow {

}

impl DemoWindow {
    pub fn new() -> Self {
        Self {

        }
    }
}

impl Application for DemoWindow {
    fn app_name(&self) -> String {
        "Demo Application".to_string()
    }

    fn attributes(&self) -> Attributes {
        Attributes::new(WS_NORMAL, "NXUI Window".to_string(),"io.github.lattesyobon.demo".to_string(),1280, 750, 100, 100)
    }

    fn is_child_window(&self) -> bool {
        false
    }

    fn startup(&self,storage: Storage) {
        println!("Startup!");
        println!("Config dir is {}",storage.get_config_dir().as_os_str().to_str().unwrap());
    }

    fn ui(&self,frame: &Frame) {
        let menubar = MenuBar::new();
        let file = MenuItem::new("File");
        let new = Menu::new("New...");
        let project = MenuItem::new("Project");
        file.add_menu(new.clone());
        file.add_separator();
        new.add_menuitem(project);
        menubar.add_menu(file);
        frame.clone().set_menu(menubar);
        frame.show();
    }

    fn exit(&self) {
        println!("Exit Application");
    }
}