//! Constants for communicating with the OS about dialog styles, etc.

#[cfg(windows)]
use windows_sys::Win32::UI::WindowsAndMessaging::*;

#[cfg(windows)]
pub type FileChooserStyle = winapi::shared::minwindef::DWORD;
#[cfg(unix)]
pub type FileChooserStyle = i32;
pub type WidgetStyle<'a> = &'a str;
#[cfg(windows)]
pub type MessageBoxStyle = windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE;
#[cfg(unix)]
pub type MessageBoxStyle = gtk::MessageType;
#[cfg(windows)]
pub type MessageBoxResult = windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_RESULT;
#[cfg(unix)]
pub type MessageBoxResult = gtk::ResponseType;
#[cfg(windows)]
pub type ButtonStyle = windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE;
#[cfg(unix)]
pub type ButtonStyle = gtk::ButtonsType;
#[cfg(windows)]
pub type WindowStyle = windows_sys::Win32::UI::WindowsAndMessaging::WINDOW_STYLE;
#[cfg(unix)]
pub type WindowStyle = gtk::WindowType;
#[cfg(windows)]
pub type AdvancedWindowStyle = windows_sys::Win32::UI::WindowsAndMessaging::WINDOW_EX_STYLE;
#[cfg(unix)]
pub type AdvancedWindowStyle = gtk::gdk::WindowTypeHint;
#[cfg(windows)]
pub type WindowColor = i32;
#[cfg(unix)]
pub type WindowColor = gtk::gdk::WindowTypeHint;
#[cfg(windows)]
pub type FontStyle = u32;
#[cfg(unix)]
pub type FontStyle = gtk::gdk::WindowTypeHint;
#[cfg(windows)]
pub type FontName = &'static str;
#[cfg(unix)]
pub type FontName = gtk::gdk::WindowTypeHint;

// Default Constants
#[cfg(windows)]
pub const DF_WINDOW_POS: i32 = windows_sys::Win32::UI::WindowsAndMessaging::CW_USEDEFAULT;
#[cfg(windows)]
pub const DF_WINDOW_SIZE: i32 = windows_sys::Win32::UI::WindowsAndMessaging::CW_USEDEFAULT;
#[cfg(unix)]
pub const DF_WINDOW_POS: i32 = 400;
#[cfg(unix)]
pub const DF_WINDOW_SIZE: i32 = 500;


// Dialog Styles

#[cfg(windows)]
#[deprecated(since = "0.16.20", note = "Please use the MS_ const")]
/// Don't show any icons
pub const DS_NONE: MessageBoxStyle =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONMASK;
#[cfg(windows)]
#[deprecated(since = "0.16.20", note = "Please use the MS_ const")]
/// Information dialog
pub const DS_INFORMATION: MessageBoxStyle =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONINFORMATION;
#[cfg(windows)]
#[deprecated(since = "0.16.20", note = "Please use the MS_ const")]
/// Question dialog
pub const DS_QUESTION: MessageBoxStyle =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONQUESTION;
#[cfg(windows)]
#[deprecated(since = "0.16.20", note = "Please use the MS_ const")]
/// Warning dialog
pub const DS_WARNING: MessageBoxStyle =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONWARNING;
#[cfg(windows)]
#[deprecated(since = "0.16.20", note = "Please use the MS_ const")]
/// Error Dialog
pub const DS_ERROR: MessageBoxStyle =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONERROR;

#[cfg(unix)]
#[deprecated(since = "0.16.20", note = "Please use the MS_ const")]
/// Don't show any icons
pub const DS_NONE: MessageBoxStyle = gtk::MessageType::Other;
#[cfg(unix)]
#[deprecated(since = "0.16.20", note = "Please use the MS_ const")]
/// Information dialog
pub const DS_INFORMATION: MessageBoxStyle = gtk::MessageType::Info;
#[cfg(unix)]
#[deprecated(since = "0.16.20", note = "Please use the MS_ const")]
/// Question dialog
pub const DS_QUESTION: MessageBoxStyle = gtk::MessageType::Question;
#[cfg(unix)]
#[deprecated(since = "0.16.20", note = "Please use the MS_ const")]
/// Warning dialog
pub const DS_WARNING: MessageBoxStyle = gtk::MessageType::Warning;
#[cfg(unix)]
#[deprecated(since = "0.16.20", note = "Please use the MS_ const")]
/// Error Dialog
pub const DS_ERROR: MessageBoxStyle = gtk::MessageType::Error;

#[cfg(windows)]
/// Don't show any icons
pub const MS_NONE: MessageBoxStyle =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONMASK;
#[cfg(windows)]
/// Information dialog
pub const MS_INFORMATION: MessageBoxStyle =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONINFORMATION;
#[cfg(windows)]
/// Question dialog
pub const MS_QUESTION: MessageBoxStyle =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONQUESTION;
#[cfg(windows)]
/// Warning dialog
pub const MS_WARNING: MessageBoxStyle =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONWARNING;
#[cfg(windows)]
/// Error Dialog
pub const MS_ERROR: MessageBoxStyle =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONERROR;

#[cfg(unix)]
/// Don't show any icons
pub const MS_NONE: MessageBoxStyle = gtk::MessageType::Other;
#[cfg(unix)]
/// Information dialog
pub const MS_INFORMATION: MessageBoxStyle = gtk::MessageType::Info;
#[cfg(unix)]
/// Question dialog
pub const MS_QUESTION: MessageBoxStyle = gtk::MessageType::Question;
#[cfg(unix)]
/// Warning dialog
pub const MS_WARNING: MessageBoxStyle = gtk::MessageType::Warning;
#[cfg(unix)]
/// Error Dialog
pub const MS_ERROR: MessageBoxStyle = gtk::MessageType::Error;

// Button Styles

#[cfg(windows)]
/// OK Button
pub const BS_OK: ButtonStyle =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_OK;
#[cfg(windows)]
/// OKCancel Buttons
pub const BS_OKCANCEL: ButtonStyle =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_OKCANCEL;
#[cfg(windows)]
/// YESNo Buttons
pub const BS_YESNO: ButtonStyle =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_YESNO;

#[cfg(unix)]
/// OK Button
pub const BS_OK: ButtonStyle = gtk::ButtonsType::Ok;
#[cfg(unix)]
/// OKCancel Buttons
pub const BS_OKCANCEL: ButtonStyle = gtk::ButtonsType::OkCancel;
#[cfg(unix)]
/// YESNo Buttons
pub const BS_YESNO: ButtonStyle = gtk::ButtonsType::YesNo;

// Dialog Results

#[cfg(windows)]
#[deprecated(since = "0.16.20", note = "Please use the MR const")]
/// If the YES button in the dialog is pressed
pub const DR_YES: MessageBoxResult =
    windows_sys::Win32::UI::WindowsAndMessaging::IDYES;
#[cfg(windows)]
#[deprecated(since = "0.16.20", note = "Please use the MR const")]
/// If the NO button in the dialog is pressed
pub const DR_NO: MessageBoxResult =
    windows_sys::Win32::UI::WindowsAndMessaging::IDNO;
#[cfg(windows)]
#[deprecated(since = "0.16.20", note = "Please use the MR const")]
/// If the OK button in the dialog is pressed
pub const DR_OK: MessageBoxResult =
    windows_sys::Win32::UI::WindowsAndMessaging::IDOK;
#[cfg(windows)]
#[deprecated(since = "0.16.20", note = "Please use the MR const")]
/// If the Cancel button in the dialog is pressed
pub const DR_CANCEL: MessageBoxResult =
    windows_sys::Win32::UI::WindowsAndMessaging::IDCANCEL;

#[cfg(unix)]
#[deprecated(since = "0.16.20", note = "Please use the MR const")]
/// If the YES button in the dialog is pressed
pub const DR_YES: MessageBoxResult = gtk::ResponseType::Yes;
#[cfg(unix)]
#[deprecated(since = "0.16.20", note = "Please use the MR const")]
/// If the NO button in the dialog is pressed
pub const DR_NO: MessageBoxResult = gtk::ResponseType::No;
#[cfg(unix)]
#[deprecated(since = "0.16.20", note = "Please use the MR const")]
/// If the OK button in the dialog is pressed
pub const DR_OK: MessageBoxResult = gtk::ResponseType::Ok;
#[cfg(unix)]
#[deprecated(since = "0.16.20", note = "Please use the MR const")]
/// If the Cancel button in the dialog is pressed
pub const DR_CANCEL: MessageBoxResult = gtk::ResponseType::Cancel;

#[cfg(windows)]
/// If the YES button in the dialog is pressed
pub const MR_YES: MessageBoxResult =
    windows_sys::Win32::UI::WindowsAndMessaging::IDYES;
#[cfg(windows)]
/// If the NO button in the dialog is pressed
pub const MR_NO: MessageBoxResult =
    windows_sys::Win32::UI::WindowsAndMessaging::IDNO;
#[cfg(windows)]
/// If the OK button in the dialog is pressed
pub const MR_OK: MessageBoxResult =
    windows_sys::Win32::UI::WindowsAndMessaging::IDOK;
#[cfg(windows)]
/// If the Cancel button in the dialog is pressed
pub const MR_CANCEL: MessageBoxResult =
    windows_sys::Win32::UI::WindowsAndMessaging::IDCANCEL;

#[cfg(unix)]
/// If the YES button in the dialog is pressed
pub const MR_YES: MessageBoxResult = gtk::ResponseType::Yes;
#[cfg(unix)]
/// If the NO button in the dialog is pressed
pub const MR_NO: MessageBoxResult = gtk::ResponseType::No;
#[cfg(unix)]
/// If the OK button in the dialog is pressed
pub const MR_OK: MessageBoxResult = gtk::ResponseType::Ok;
#[cfg(unix)]
/// If the Cancel button in the dialog is pressed
pub const MR_CANCEL: MessageBoxResult = gtk::ResponseType::Cancel;

// Window Styles

#[cfg(windows)]
/// Standard window
pub const WS_NORMAL: WindowStyle =
    windows_sys::Win32::UI::WindowsAndMessaging::WS_OVERLAPPEDWINDOW;
#[cfg(windows)]
/// A window with only a close button
pub const WS_ONLYEXIT: WindowStyle =
    windows_sys::Win32::UI::WindowsAndMessaging::WS_SYSMENU;
#[cfg(windows)]
pub const WS_DISABLE_MAXIMIZE:WindowStyle = WS_CAPTION|WS_SYSMENU|WS_THICKFRAME|WS_MINIMIZEBOX;
#[cfg(windows)]
pub const WS_DISABLE_MAXIMIZE_MINIMIZE:windows_sys::Win32::UI::WindowsAndMessaging::WINDOW_STYLE = WS_CAPTION|WS_SYSMENU|WS_THICKFRAME;

#[cfg(unix)]
/// Standard window
pub const WS_NORMAL: WindowStyle = gtk::WindowType::Toplevel;
#[cfg(unix)]
/// A window with only a close button
pub const WS_NOCAPTION: WindowStyle = gtk::WindowType::Popup;

#[cfg(windows)]
pub const AWS_UTILITY: AdvancedWindowStyle =
    windows_sys::Win32::UI::WindowsAndMessaging::WS_EX_TOOLWINDOW;
#[cfg(windows)]
pub const AWS_NONE: AdvancedWindowStyle = 0;
#[cfg(unix)]
pub const AWS_UTILITY: AdvancedWindowStyle = gtk::gdk::WindowTypeHint::Utility;
#[cfg(unix)]
pub const AWS_NONE: AdvancedWindowStyle = gtk::gdk::WindowTypeHint::Normal;

/// File Chooser Attributes
#[cfg(windows)]
pub const FC_NONE: FileChooserStyle = 0;
#[cfg(unix)]
pub const FC_NONE: FileChooserStyle = 0;
#[cfg(windows)]
pub const FC_DISABLE_READ_ONLY: FileChooserStyle =
    winapi::um::commdlg::OFN_HIDEREADONLY;
#[cfg(unix)]
pub const FC_DISABLE_READ_ONLY: FileChooserStyle = 0;
/// Windows Only
#[cfg(windows)]
pub const FC_NEW_EXPLORER: FileChooserStyle = winapi::um::commdlg::OFN_EXPLORER;
#[cfg(windows)]
pub const FC_ENABLE_HELP: FileChooserStyle = winapi::um::commdlg::OFN_SHOWHELP;

#[cfg(windows)]
pub const WC_NULL: WindowColor = 0;
#[cfg(windows)]
pub const WC_GRAY: WindowColor = 22;
#[cfg(windows)]
pub const WC_DEFAULT: WindowColor = 5;
#[cfg(windows)]
pub const WC_BLUE: WindowColor = 14;
#[cfg(windows)]
pub const WC_LIGHT_GRAY: WindowColor = 11;
#[cfg(windows)]
pub const WC_WHITE: WindowColor = 6;
#[cfg(windows)]
pub const WC_LIGHT_BLUE: WindowColor = 3;
#[cfg(windows)]
pub const WC_BLACK: WindowColor = 2;

#[cfg(windows)]
pub const FS_MEDIUM: FontStyle = windows_sys::Win32::Graphics::Gdi::FW_MEDIUM;
#[cfg(windows)]
pub const FS_LIGHT: FontStyle = windows_sys::Win32::Graphics::Gdi::FW_LIGHT;
#[cfg(windows)]
pub const FS_BOLD: FontStyle = windows_sys::Win32::Graphics::Gdi::FW_BOLD;
#[cfg(windows)]
pub const FS_THIN: FontStyle = windows_sys::Win32::Graphics::Gdi::FW_THIN;

#[cfg(windows)]
pub const FN_YU_GOTHIC: FontName = "Yu Gothic\0";
#[cfg(windows)]
pub const FN_GOTHIC: FontName = "Gothic\0";
#[cfg(windows)]
pub const FN_MEIRYO: FontName = "Meiryo\0";
#[cfg(windows)]
pub const FN_MEIRYO_UI: FontName = "Meiryo UI\0";
#[cfg(windows)]
pub const FN_MS_GOTHIC: FontName = "MS Gothic\0";
#[cfg(windows)]
pub const FN_MS_UI_GOTHIC: FontName = "MS UI Gothic\0";
#[cfg(windows)]
pub const FN_ARIAL: FontName = "Arial\0";

