#[cfg(windows)]
pub struct Icon {
    icon: windows_sys::Win32::UI::WindowsAndMessaging::HICON,
}

#[cfg(windows)]
impl Icon {
    pub fn new(name: String) -> Self {
        use windows_sys::Win32::UI::WindowsAndMessaging::*;
        let hIcon = unsafe {
            LoadImageA(
                0,
                format!("{}\0", name).as_ptr(),
                IMAGE_ICON,
                0,
                0,
                LR_SHARED | LR_LOADFROMFILE,
            )
        };
        Self { icon: hIcon }
    }

    #[no_mangle] pub extern "C" fn new_icon(name: String) -> Self {
        use windows_sys::Win32::UI::WindowsAndMessaging::*;
        let hIcon = unsafe {
            LoadImageA(
                0,
                format!("{}\0", name).as_ptr(),
                IMAGE_ICON,
                0,
                0,
                LR_SHARED | LR_LOADFROMFILE,
            )
        };
        Self { icon: hIcon }
    }

    #[no_mangle] pub extern "C" fn get_icon(&self) -> windows_sys::Win32::UI::WindowsAndMessaging::HICON {
        self.icon
    }
}

#[cfg(windows)]
impl Default for Icon {
    fn default() -> Self {
        Self { icon: 0 }
    }
}

#[cfg(unix)]
pub struct Icon {
    file_name: String,
}

#[cfg(unix)]
impl Icon {
    pub fn new(name: String) -> Self {
        Self { file_name: name }
    }

    #[no_mangle] pub extern "C" fn new_icon(name: String) -> Self {
        Self { file_name: name }
    }

    #[no_mangle] pub extern "C" fn get_file_name(self) -> String {
        self.file_name
    }
}

#[cfg(unix)]
impl Default for Icon {
    fn default() -> Self {
        Self {
            file_name: String::default(),
        }
    }
}
