use crate::natives_and_messaging::*;

#[cfg(windows)]
pub struct Font {
    font: windows_sys::Win32::Graphics::Gdi::HFONT
}

#[cfg(windows)]
impl Font {
    pub fn new(font_size: i32,font_style: FontStyle,font_name: FontName) -> Self {
        use windows_sys::Win32::Foundation::WPARAM;
        use windows_sys::Win32::Graphics::Gdi::OUT_DEFAULT_PRECIS;
        use windows_sys::Win32::Graphics::Gdi::{CLIP_DEFAULT_PRECIS, CreateFontA, DEFAULT_QUALITY, FF_ROMAN, FW_MEDIUM, HFONT, SHIFTJIS_CHARSET, VARIABLE_PITCH};
        let f = unsafe { CreateFontA(font_size, 0, 0, 0, font_style as i32, 0, 0, 0, SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, VARIABLE_PITCH | FF_ROMAN, font_name.as_ptr()) };
        Self {
            font: f
        }
    }

    pub fn get_font(&self) -> windows_sys::Win32::Graphics::Gdi::HFONT {
        self.font
    }
}

#[cfg(unix)]
pub struct Font {
    font: i32
}

#[cfg(unix)]
impl Font {
    pub fn new(font_size: i32,font_style: FontStyle,font_name: FontName) -> Self {
        Self {
            font: 0
        }
    }

    pub fn get_font(&self) -> i32 {
        self.font
    }
}