//! Provides useful methods and more for applications using NXUI

#[cfg(windows)]
use winapi::um::winnt::PWSTR;

#[cfg(windows)]
#[no_mangle] pub extern "C" fn get_os() -> &'static str {
    "Windows"
}

#[cfg(macos)]
#[no_mangle] pub extern "C" fn get_os() -> &'static str {
    "MacOS"
}

#[cfg(unix)]
#[no_mangle] pub extern "C" fn get_os() -> &'static str {
    "Unix"
}

#[cfg(windows)]
#[no_mangle] pub extern "C" fn pwstr_to_string(ptr: PWSTR) -> String {
    unsafe {
        use std::slice::from_raw_parts;
        let len = (0_usize..)
            .find(|&n| *ptr.offset(n as isize) == 0)
            .expect("Couldn't find null terminator");
        let array: &[u16] = from_raw_parts(ptr, len);
        String::from_utf16_lossy(array)
    }
}
