//! Constants for communicating with the OS about dialog styles, etc.

#[cfg(windows)]
use windows_sys::Win32::UI::WindowsAndMessaging::*;

pub type FileChooserStyle = i32;
pub type WidgetStyle<'a> = &'a str;

// Default Constants
#[cfg(windows)]
pub const DF_WINDOW_POS: i32 = windows_sys::Win32::UI::WindowsAndMessaging::CW_USEDEFAULT;
#[cfg(windows)]
pub const DF_WINDOW_SIZE: i32 = windows_sys::Win32::UI::WindowsAndMessaging::CW_USEDEFAULT;
#[cfg(unix)]
pub const DF_WINDOW_POS: i32 = 400;
#[cfg(unix)]
pub const DF_WINDOW_SIZE: i32 = 500;


// Dialog Styles

#[cfg(windows)]
/// Don't show any icons
pub const DS_NONE: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONMASK;
#[cfg(windows)]
/// Information dialog
pub const DS_INFORMATION: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONINFORMATION;
#[cfg(windows)]
/// Question dialog
pub const DS_QUESTION: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONQUESTION;
#[cfg(windows)]
/// Warning dialog
pub const DS_WARNING: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONWARNING;
#[cfg(windows)]
/// Error Dialog
pub const DS_ERROR: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONERROR;

#[cfg(unix)]
/// Don't show any icons
pub const DS_NONE: gtk::MessageType = gtk::MessageType::Other;
#[cfg(unix)]
/// Information dialog
pub const DS_INFORMATION: gtk::MessageType = gtk::MessageType::Info;
#[cfg(unix)]
/// Question dialog
pub const DS_QUESTION: gtk::MessageType = gtk::MessageType::Question;
#[cfg(unix)]
/// Warning dialog
pub const DS_WARNING: gtk::MessageType = gtk::MessageType::Warning;
#[cfg(unix)]
/// Error Dialog
pub const DS_ERROR: gtk::MessageType = gtk::MessageType::Error;

// Button Styles

#[cfg(windows)]
/// OK Button
pub const BS_OK: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_OK;
#[cfg(windows)]
/// OKCancel Buttons
pub const BS_OKCANCEL: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_OKCANCEL;
#[cfg(windows)]
/// YESNo Buttons
pub const BS_YESNO: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_YESNO;

#[cfg(unix)]
/// OK Button
pub const BS_OK: gtk::ButtonsType = gtk::ButtonsType::Ok;
#[cfg(unix)]
/// OKCancel Buttons
pub const BS_OKCANCEL: gtk::ButtonsType = gtk::ButtonsType::OkCancel;
#[cfg(unix)]
/// YESNo Buttons
pub const BS_YESNO: gtk::ButtonsType = gtk::ButtonsType::YesNo;

// Dialog Results

#[cfg(windows)]
/// If the YES button in the dialog is pressed
pub const DR_YES: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_RESULT =
    windows_sys::Win32::UI::WindowsAndMessaging::IDYES;
#[cfg(windows)]
/// If the NO button in the dialog is pressed
pub const DR_NO: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_RESULT =
    windows_sys::Win32::UI::WindowsAndMessaging::IDNO;
#[cfg(windows)]
/// If the OK button in the dialog is pressed
pub const DR_OK: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_RESULT =
    windows_sys::Win32::UI::WindowsAndMessaging::IDOK;
#[cfg(windows)]
/// If the Cancel button in the dialog is pressed
pub const DR_CANCEL: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_RESULT =
    windows_sys::Win32::UI::WindowsAndMessaging::IDCANCEL;

#[cfg(unix)]
/// If the YES button in the dialog is pressed
pub const DR_YES: gtk::ResponseType = gtk::ResponseType::Yes;
#[cfg(unix)]
/// If the NO button in the dialog is pressed
pub const DR_NO: gtk::ResponseType = gtk::ResponseType::No;
#[cfg(unix)]
/// If the OK button in the dialog is pressed
pub const DR_OK: gtk::ResponseType = gtk::ResponseType::Ok;
#[cfg(unix)]
/// If the Cancel button in the dialog is pressed
pub const DR_CANCEL: gtk::ResponseType = gtk::ResponseType::Cancel;

// Window Styles

#[cfg(windows)]
/// Standard window
pub const WS_NORMAL: windows_sys::Win32::UI::WindowsAndMessaging::WINDOW_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::WS_OVERLAPPEDWINDOW;
#[cfg(windows)]
/// A window with only a close button
pub const WS_ONLYEXIT: windows_sys::Win32::UI::WindowsAndMessaging::WINDOW_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::WS_SYSMENU;
#[cfg(windows)]
pub const WS_DISABLE_MAXIMIZE:windows_sys::Win32::UI::WindowsAndMessaging::WINDOW_STYLE = WS_CAPTION|WS_SYSMENU|WS_THICKFRAME|WS_MINIMIZEBOX;
#[cfg(windows)]
pub const WS_DISABLE_MAXIMIZE_MINIMIZE:windows_sys::Win32::UI::WindowsAndMessaging::WINDOW_STYLE = WS_CAPTION|WS_SYSMENU|WS_THICKFRAME;

#[cfg(unix)]
/// Standard window
pub const WS_NORMAL: gtk::WindowType = gtk::WindowType::Toplevel;
#[cfg(unix)]
/// A window with only a close button
pub const WS_NOCAPTION: gtk::WindowType = gtk::WindowType::Popup;

#[cfg(windows)]
pub const AWS_UTILITY: windows_sys::Win32::UI::WindowsAndMessaging::WINDOW_EX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::WS_EX_TOOLWINDOW;
#[cfg(windows)]
pub const AWS_NONE: windows_sys::Win32::UI::WindowsAndMessaging::WINDOW_EX_STYLE = 0;
#[cfg(unix)]
pub const AWS_UTILITY: gtk::gdk::WindowTypeHint = gtk::gdk::WindowTypeHint::Utility;
#[cfg(unix)]
pub const AWS_NONE: gtk::gdk::WindowTypeHint = gtk::gdk::WindowTypeHint::Normal;

/// File Chooser Attributes
#[cfg(windows)]
pub const FC_NONE: winapi::shared::minwindef::DWORD = 0;
#[cfg(unix)]
pub const FC_NONE: FileChooserStyle = 0;
#[cfg(windows)]
pub const FC_DISABLE_READ_ONLY: winapi::shared::minwindef::DWORD =
    winapi::um::commdlg::OFN_HIDEREADONLY;
#[cfg(unix)]
pub const FC_DISABLE_READ_ONLY: FileChooserStyle = 0;
/// Windows Only
#[cfg(windows)]
pub const FC_NEW_EXPLORER: winapi::shared::minwindef::DWORD = winapi::um::commdlg::OFN_EXPLORER;
#[cfg(windows)]
pub const FC_ENABLE_HELP: winapi::shared::minwindef::DWORD = winapi::um::commdlg::OFN_SHOWHELP;

#[cfg(windows)]
pub const WC_NULL: i32 = 0;
#[cfg(windows)]
pub const WC_GRAY: i32 = 22;
#[cfg(windows)]
pub const WC_DEFAULT: i32 = 5;
#[cfg(windows)]
pub const WC_BLUE: i32 = 14;
#[cfg(windows)]
pub const WC_LIGHT_GRAY: i32 = 11;
#[cfg(windows)]
pub const WC_WHITE: i32 = 6;
#[cfg(windows)]
pub const WC_LIGHT_BLUE: i32 = 3;
#[cfg(windows)]
pub const WC_BLACK: i32 = 2;

#[deprecated(since = "0.15.2", note = "Please use the respective widget structure")]
pub const WT_BUTTON: WidgetStyle = "BUTTON\0";
#[deprecated(since = "0.15.2", note = "Please use the respective widget structure")]
pub const WT_TEXTEDIT: WidgetStyle = "EDIT\0";
