#![windows_subsystem = "windows"]

use nxui::graphic::icon::Icon;
use nxui::natives_and_messaging::*;
use nxui::window::{AdvancedOptions, Application, Attributes, Frame};

fn main() {
    nxui::initialize();
    let app = IconWindow::new();
    nxui::nxui::create_new_app(Box::new(app));
}

struct IconWindow {}

impl IconWindow {
    pub fn new() -> Self {
        Self {}
    }
}

impl Application for IconWindow {
    fn app_name(&self) -> String {
        "Icon App".to_string()
    }

    fn attributes(&self) -> Attributes {
        Attributes::new(
            WS_NORMAL,
            "Icon Window".to_string(),
            "io.github.lattesyobon.icon".to_string(),
            400,
            675,
            100,
            100,
        )
    }

    fn is_child_window(&self) -> bool {
        false
    }

    fn advanced_options(&self) -> AdvancedOptions {
        AdvancedOptions::new(AWS_NONE,WC_DEFAULT)
    }

    fn ui(&self, frame: &Frame) {
        #[cfg(windows)]
        let icon: Icon = Icon::new("icon.ico".to_string());
        #[cfg(unix)]
        let icon: Icon = Icon::new("icon.png".to_string());
        frame.set_icon(icon);
        frame.show();
    }
}
