//! Sample dialog window

use crate::natives_and_messaging::WS_NORMAL;
use crate::window::dialog::Dialog;
use crate::window::{Attributes, Frame};

pub struct DemoDialog {}

impl DemoDialog {
    pub fn new() -> Self {
        Self {}
    }
}

impl Dialog for DemoDialog {
    fn attributes(&self) -> Attributes {
        Attributes::new(
            WS_NORMAL,
            "Demo Dialog".to_string(),
            "io.github.lattesyobon.demo".to_string(),
            320,
            250,
            50,
            50,
        )
    }

    fn frame(&self) -> Frame {
        Frame::default()
    }

    fn ui(&self, frame: Frame) {
        frame.show();
    }
}
