use nxui::messagebox::MessageBox;
use nxui::natives_and_messaging::WS_NORMAL;
use nxui::widget::combobox::ComboBox;
use nxui::widget::listbox::ListBox;
use nxui::widget::menu::Menu;
use nxui::widget::menubar::MenuBar;
use nxui::widget::menuitem::MenuItem;
use nxui::widget::textedit::TextEdit;
use nxui::window::{Application, Attributes, Frame};

fn main() {
    nxui::initialize();
    let win = WidgetWindow::new();
    nxui::nxui::create_new_app(Box::new(win));
}

struct WidgetWindow {}

impl WidgetWindow {
    pub fn new() -> Self {
        Self {}
    }
}

impl Application for WidgetWindow {
    fn app_name(&self) -> String {
        "Widget Application".to_string()
    }

    fn attributes(&self) -> Attributes {
        Attributes::new(
            WS_NORMAL,
            "Widget Window".to_string(),
            "io.github.lattesyobon.widget".to_string(),
            1280,
            750,
            100,
            100,
        )
    }

    fn is_child_window(&self) -> bool {
        true
    }

    fn ui(&self, frame: &Frame) {
        use nxui::widget::button::Button;
        use nxui::widget::checkbox::CheckBox;
        use nxui::widget::label::Label;
        use nxui::widget::radiobutton::RadioButton;
        Label::new(
            Attributes::new(
                WS_NORMAL,
                "Button Controls".to_string(),
                "".to_string(),
                350,
                250,
                50,
                50,
            ),
            frame,
        )
        .show();

        Button::new(
            Attributes::new(
                WS_NORMAL,
                "Push Button".to_string(),
                "".to_string(),
                350,
                250,
                100,
                100,
            ),
            frame,
        )
        .show();
        CheckBox::new(
            Attributes::new(
                WS_NORMAL,
                "Check Box".to_string(),
                "".to_string(),
                150,
                250,
                500,
                100,
            ),
            frame,
        )
        .show();
        RadioButton::new(
            Attributes::new(
                WS_NORMAL,
                "Radio Button".to_string(),
                "".to_string(),
                250,
                250,
                650,
                100,
            ),
            frame,
        )
        .show();

        Label::new(
            Attributes::new(
                WS_NORMAL,
                "Text Edit".to_string(),
                "".to_string(),
                350,
                50,
                50,
                400,
            ),
            frame,
        )
        .show();
        Label::new(
            Attributes::new(
                WS_NORMAL,
                "Combo Box".to_string(),
                "".to_string(),
                350,
                50,
                650,
                400,
            ),
            frame,
        )
        .show();
        TextEdit::new(
            Attributes::new(
                WS_NORMAL,
                "Text Edit".to_string(),
                "".to_string(),
                550,
                200,
                50,
                450,
            ),
            frame,
        )
        .show();
        ComboBox::new(
            Attributes::new(
                WS_NORMAL,
                "Rich Text Edit".to_string(),
                "".to_string(),
                550,
                45,
                650,
                450,
            ),
            frame,
        )
        .show();
        Label::new(
            Attributes::new(
                WS_NORMAL,
                "List Box".to_string(),
                "".to_string(),
                350,
                50,
                650,
                510,
            ),
            frame,
        )
        .show();
        ListBox::new(
            Attributes::new(
                WS_NORMAL,
                "List Box".to_string(),
                "".to_string(),
                350,
                115,
                650,
                540,
            ),
            frame,
        )
        .show();

        // Initialize Menu
        let menu = initialize_menu();
        frame.clone().set_menu(menu);

        frame.show();
    }
}

fn initialize_menu() -> MenuBar {
    let menu_bar = MenuBar::new();

    // Initialize Menu
    let file_menu = MenuItem::new("File");
    let edit_menu = MenuItem::new("Edit");
    let help_menu = MenuItem::new("Help");
    menu_bar.add_menu(file_menu.clone());
    menu_bar.add_menu(edit_menu.clone());
    menu_bar.add_menu(help_menu.clone());

    // Initialize MenuItem
    // Initialize File Menu
    let new_menu = Menu::new("New...");
    let project_item = MenuItem::new("Project");
    let exit_item = MenuItem::new("Exit");
    new_menu.add_menuitem(project_item);
    file_menu.add_menu(new_menu.clone());
    file_menu.add_separator();
    file_menu.add_menuitem(exit_item);

    // Initialize Edit Menu
    let undo_item = MenuItem::new("Undo");
    let redo_item = MenuItem::new("Redo");
    let cut_item = MenuItem::new("Cut");
    let copy_item = MenuItem::new("Copy");
    edit_menu.add_menuitem(undo_item);
    edit_menu.add_menuitem(redo_item);
    edit_menu.add_separator();
    edit_menu.add_menuitem(cut_item);
    edit_menu.add_menuitem(copy_item);

    // Initialize Help Menu
    let about_item = MenuItem::new("About this Sample");
    help_menu.add_menuitem(about_item);
    menu_bar
}
