use nxui::graphic::icon::Icon;
use nxui::natives_and_messaging::{AWS_UTILITY, WS_NORMAL};
use nxui::window::{AdvancedOptions, Application, Attributes, Frame};

fn main() {
    nxui::initialize();
    let app = UtilityApplication::new();
    nxui::nxui::create_new_app(Box::new(app));
}

struct UtilityApplication {}

impl UtilityApplication {
    pub fn new() -> Self {
        Self {}
    }
}

impl Application for UtilityApplication {
    fn app_name(&self) -> String {
        "Utility App".to_string()
    }

    fn attributes(&self) -> Attributes {
        Attributes::new(
            WS_NORMAL,
            "Utility Window".to_string(),
            "io.github.lattesyobon.utility".to_string(),
            400,
            675,
            100,
            100,
        )
    }

    fn is_child_window(&self) -> bool {
        false
    }

    fn advanced_options(&self) -> AdvancedOptions {
        AdvancedOptions::new(AWS_UTILITY, Icon::default().get_icon())
    }

    fn ui(&self, frame: &Frame) {
        frame.show();
    }
}
