use nxui::messagebox::MessageBox;
use nxui::natives_and_messaging::WS_NORMAL;
use nxui::window::{Application, Attributes, Frame};

fn main() {
    nxui::initialize();
    let win = WidgetWindow::new();
    nxui::nxui::create_new_app(Box::new(win));
}

struct WidgetWindow {

}

impl WidgetWindow {
    pub fn new() -> Self {
        Self {

        }
    }
}

impl Application for WidgetWindow {
    fn app_name(&self) -> String {
        "Widget Application".to_string()
    }

    fn attributes(&self) -> Attributes {
        Attributes::new(WS_NORMAL, "Widget Window".to_string(),1280, 750, 100, 100)
    }

    fn is_child_window(&self) -> bool {
        true
    }

    fn ui(&self, frame: Frame) {
        use nxui::widget::button::Button;
        use nxui::widget::checkbox::CheckBox;
        use nxui::widget::label::Label;
        use nxui::widget::radiobutton::RadioButton;
        use nxui::widget::textedit::TextEdit;
        Label::new(Attributes::new(0, "Button Controls".to_string(), 350, 250, 50, 50), frame).show();

        Button::new(Attributes::new(0, "Push Button".to_string(), 350, 250, 100, 100), frame).show();
        CheckBox::new(Attributes::new(0, "Check Box".to_string(), 150, 250, 500, 100), frame).show();
        RadioButton::new(Attributes::new(0, "Radio Button".to_string(), 250, 250, 650, 100), frame).show();

        Label::new(Attributes::new(0, "Text Edit".to_string(), 350, 50, 50, 400), frame).show();
        TextEdit::new(Attributes::new(0, "Text Edit".to_string(), 550, 200, 50, 450), frame).show();
        frame.show();
    }
}