use crate::window::{Attributes, Frame};

pub struct RadioButton {
    pub handle: windows_sys::Win32::Foundation::HWND
}

impl RadioButton {
    pub fn new(attributes: Attributes,frame: Frame) -> Self {
        use windows_sys::Win32::UI::WindowsAndMessaging::*;
        unsafe {
            let handle = CreateWindowExA(0, "BUTTON\0".as_ptr(), format!("{}\0",attributes.title).as_ptr(), WS_CHILD|BS_AUTORADIOBUTTON as u32, attributes.x, attributes.y, attributes.width, attributes.height, frame.get_window(), 0, 0, std::ptr::null_mut());
            Self {
                handle
            }
        }
    }

    pub fn show(&self) {
        use windows_sys::Win32::UI::WindowsAndMessaging::ShowWindow;
        use windows_sys::Win32::UI::WindowsAndMessaging::SW_SHOWNORMAL;
        unsafe {
            ShowWindow(self.handle,SW_SHOWNORMAL);
            info!("handle: {}",self.handle);
        }
    }
}