//! Provides widgets for building the UI

pub mod button;
pub mod checkbox;
pub mod radiobutton;
pub mod label;

use windows_sys::Win32::Foundation::HINSTANCE;
use windows_sys::Win32::Graphics::Gdi::BS_DIBPATTERN;
use windows_sys::Win32::UI::WindowsAndMessaging::*;
use crate::natives_and_messaging::WidgetStyle;
use crate::window::{Attributes, Frame};

#[deprecated(since="0.15.2", note="Please use the respective widget structure")]
pub struct Widget {
    pub handle: windows_sys::Win32::Foundation::HWND
}

#[deprecated(since="0.15.2", note="Please use the respective widget structure")]
impl Widget {
    pub fn new(widget_type:WidgetStyle,attributes: Attributes,frame: Frame) -> Self {
        use windows_sys::Win32::UI::WindowsAndMessaging::CreateWindowExA;
        unsafe {
            let handle = CreateWindowExA(0, widget_type.as_ptr(), format!("{}\0",attributes.title).as_ptr(), WS_CHILD, attributes.x, attributes.y, attributes.width, attributes.height, frame.get_window(), 0, 0, std::ptr::null_mut());
            Self {
                handle
            }
        }
    }

    pub fn show(&self) {
        use windows_sys::Win32::UI::WindowsAndMessaging::ShowWindow;
        use windows_sys::Win32::UI::WindowsAndMessaging::SW_SHOWNORMAL;
        unsafe {
            ShowWindow(self.handle,SW_SHOWNORMAL);
            info!("handle: {}",self.handle);
        }
    }
}