use crate::window::{Attributes, Frame};

pub struct Label {
    pub handle: windows_sys::Win32::Foundation::HWND
}

impl Label {
    pub fn new(attributes: Attributes,frame: Frame) -> Self {
        use windows_sys::Win32::UI::WindowsAndMessaging::*;
        unsafe {
            let handle = CreateWindowExA(0, "Static\0".as_ptr(), format!("{}\0",attributes.title).as_ptr(), WS_CHILD, attributes.x, attributes.y, attributes.width, attributes.height, frame.get_window(), 0, 0, std::ptr::null_mut());
            Self {
                handle
            }
        }
    }

    pub fn show(&self) {
        use windows_sys::Win32::UI::WindowsAndMessaging::ShowWindow;
        use windows_sys::Win32::UI::WindowsAndMessaging::SW_SHOWNORMAL;
        unsafe {
            ShowWindow(self.handle,SW_SHOWNORMAL);
            info!("handle: {}",self.handle);
        }
    }
}