use crate::io::storage::Storage;
use crate::natives_and_messaging::*;
use crate::widget::label::Label;
use crate::widget::radiobutton::RadioButton;
use crate::window::{Application, Frame, Attributes};

pub struct DemoWindow {

}

impl DemoWindow {
    pub fn new() -> Self {
        Self {

        }
    }
}

impl Application for DemoWindow {
    fn app_name(&self) -> String {
        "Demo Application".to_string()
    }

    fn attributes(&self) -> Attributes {
        Attributes::new(WS_NORMAL, "NXUI Window".to_string(),1280, 750, 100, 100)
    }

    fn is_child_window(&self) -> bool {
        false
    }

    fn startup(&self,storage: Storage) {
        println!("Startup!");
        println!("Config dir is {}",storage.get_config_dir().as_os_str().to_str().unwrap());
    }

    fn ui(&self,frame: Frame) {
        use crate::widget::button::Button;
        use crate::widget::checkbox::CheckBox;
        Label::new(Attributes::new(0, "Button Controls".to_string(), 350, 250, 50, 50), frame).show();

        Button::new(Attributes::new(0, "Push Button".to_string(), 350, 250, 100, 100), frame).show();
        CheckBox::new(Attributes::new(0, "Check Box".to_string(), 150, 250, 500, 100), frame).show();
        RadioButton::new(Attributes::new(0, "Radio Button".to_string(), 250, 250, 650, 100), frame).show();
        // Deprecated
        // Widget::new(WT_BUTTON, Attributes::new(0, "BUTTON".to_string(), 350, 250, 100, 100), frame).show();
        frame.show();
    }

    fn exit(&self) {
        println!("Exit Application");
    }
}