//! Constants for communicating with the OS about dialog styles, etc.
//! What starts with DIALOGSTYLE is Constants that set the dialog icon information.
//! What starts with BUTTONSTYLE is a constant for changing the buttons in the dialog.

// Dialog Styles



#[cfg(windows)]
#[deprecated(since="0.14.6", note="Please use `DS_NONE` instead")]
/// Don't show any icons
pub const DIALOGSTYLE_NONE: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONMASK;
#[cfg(windows)]
#[deprecated(since="0.14.6", note="Please use `DS_INFORMATION` instead")]
/// Information dialog
pub const DIALOGSTYLE_INFORMATION: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONINFORMATION;
#[cfg(windows)]
#[deprecated(since="0.14.6", note="Please use `DS_QUESTION` instead")]
/// Question dialog
pub const DIALOGSTYLE_QUESTION: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONQUESTION;
#[cfg(windows)]
#[deprecated(since="0.14.6", note="Please use `DS_WARNING` instead")]
/// Warning dialog
pub const DIALOGSTYLE_WARNING: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONWARNING;
#[cfg(windows)]
#[deprecated(since="0.14.6", note="Please use `DS_ERROR` instead")]
/// Error Dialog
pub const DIALOGSTYLE_ERROR: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONERROR;

#[cfg(windows)]
/// Don't show any icons
pub const DS_NONE: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONMASK;
#[cfg(windows)]
/// Information dialog
pub const DS_INFORMATION: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONINFORMATION;
#[cfg(windows)]
/// Question dialog
pub const DS_QUESTION: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONQUESTION;
#[cfg(windows)]
/// Warning dialog
pub const DS_WARNING: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONWARNING;
#[cfg(windows)]
/// Error Dialog
pub const DS_ERROR: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_ICONERROR;


#[cfg(unix)]
#[deprecated(since="0.14.6", note="Please use `DS_NONE` instead")]
/// Don't show any icons
pub const DIALOGSTYLE_NONE: gtk::MessageType = gtk::MessageType::Other;
#[cfg(unix)]
#[deprecated(since="0.14.6", note="Please use `DS_INFORMATION` instead")]
/// Information dialog
pub const DIALOGSTYLE_INFORMATION: gtk::MessageType = gtk::MessageType::Info;
#[cfg(unix)]
#[deprecated(since="0.14.6", note="Please use `DS_QUESTION` instead")]
/// Question dialog
pub const DIALOGSTYLE_QUESTION: gtk::MessageType = gtk::MessageType::Question;
#[cfg(unix)]
#[deprecated(since="0.14.6", note="Please use `DS_WARNING` instead")]
/// Warning dialog
pub const DIALOGSTYLE_WARNING: gtk::MessageType = gtk::MessageType::Warning;
#[cfg(unix)]
#[deprecated(since="0.14.6", note="Please use `DS_ERROR` instead")]
/// Error Dialog
pub const DIALOGSTYLE_ERROR: gtk::MessageType = gtk::MessageType::Error;

#[cfg(unix)]
/// Don't show any icons
pub const DS_NONE: gtk::MessageType = gtk::MessageType::Other;
#[cfg(unix)]
/// Information dialog
pub const DS_INFORMATION: gtk::MessageType = gtk::MessageType::Info;
#[cfg(unix)]
/// Question dialog
pub const DS_QUESTION: gtk::MessageType = gtk::MessageType::Question;
#[cfg(unix)]
/// Warning dialog
pub const DS_WARNING: gtk::MessageType = gtk::MessageType::Warning;
#[cfg(unix)]
/// Error Dialog
pub const DS_ERROR: gtk::MessageType = gtk::MessageType::Error;

// Button Styles

#[cfg(windows)]
#[deprecated(since="0.14.6", note="Please use `BS_OK` instead")]
/// OK Button
pub const BUTTONSTYLE_OK: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_OK;
#[cfg(windows)]
#[deprecated(since="0.14.6", note="Please use `BS_OKCANCEL` instead")]
/// OKCancel Buttons
pub const BUTTONSTYLE_OKCANCEL: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_OKCANCEL;
#[cfg(windows)]
#[deprecated(since="0.14.6", note="Please use `BS_YESNO` instead")]
/// YESNo Buttons
pub const BUTTONSTYLE_YESNO: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_YESNO;

#[cfg(windows)]
/// OK Button
pub const BS_OK: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_OK;
#[cfg(windows)]
/// OKCancel Buttons
pub const BS_OKCANCEL: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_OKCANCEL;
#[cfg(windows)]
/// YESNo Buttons
pub const BS_YESNO: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE =
    windows_sys::Win32::UI::WindowsAndMessaging::MB_YESNO;


#[cfg(unix)]
#[deprecated(since="0.14.6", note="Please use `BS_OK` instead")]
/// OK Button
pub const BUTTONSTYLE_OK: gtk::ButtonsType = gtk::ButtonsType::Ok;
#[cfg(unix)]
#[deprecated(since="0.14.6", note="Please use `BS_OKCANCEL` instead")]
/// OKCancel Buttons
pub const BUTTONSTYLE_OKCANCEL: gtk::ButtonsType = gtk::ButtonsType::OkCancel;
#[cfg(unix)]
#[deprecated(since="0.14.6", note="Please use `BS_YESNO` instead")]
/// YESNo Buttons
pub const BUTTONSTYLE_YESNO: gtk::ButtonsType = gtk::ButtonsType::YesNo;

#[cfg(unix)]
/// OK Button
pub const BS_OK: gtk::ButtonsType = gtk::ButtonsType::Ok;
#[cfg(unix)]
/// OKCancel Buttons
pub const BS_OKCANCEL: gtk::ButtonsType = gtk::ButtonsType::OkCancel;
#[cfg(unix)]
/// YESNo Buttons
pub const BS_YESNO: gtk::ButtonsType = gtk::ButtonsType::YesNo;

// Dialog Results

#[cfg(windows)]
#[deprecated(since="0.14.6", note="Please use `DR_YES` instead")]
/// If the YES button in the dialog is pressed
pub const RESULTS_YES: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_RESULT =
    windows_sys::Win32::UI::WindowsAndMessaging::IDYES;
#[cfg(windows)]
#[deprecated(since="0.14.6", note="Please use `DR_NO` instead")]
/// If the NO button in the dialog is pressed
pub const RESULTS_NO: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_RESULT =
    windows_sys::Win32::UI::WindowsAndMessaging::IDNO;
#[cfg(windows)]
#[deprecated(since="0.14.6", note="Please use `DR_OK` instead")]
/// If the OK button in the dialog is pressed
pub const RESULTS_OK: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_RESULT =
    windows_sys::Win32::UI::WindowsAndMessaging::IDOK;
#[cfg(windows)]
#[deprecated(since="0.14.6", note="Please use `DR_CANCEL` instead")]
/// If the Cancel button in the dialog is pressed
pub const RESULTS_CANCEL: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_RESULT =
    windows_sys::Win32::UI::WindowsAndMessaging::IDCANCEL;

#[cfg(unix)]
#[deprecated(since="0.14.6", note="Please use `DR_YES` instead")]
/// If the YES button in the dialog is pressed
pub const RESULTS_YES: gtk::ResponseType = gtk::ResponseType::Yes;
#[cfg(unix)]
#[deprecated(since="0.14.6", note="Please use `DR_NO` instead")]
/// If the NO button in the dialog is pressed
pub const RESULTS_NO: gtk::ResponseType = gtk::ResponseType::No;
#[cfg(unix)]
#[deprecated(since="0.14.6", note="Please use `DR_OK` instead")]
/// If the OK button in the dialog is pressed
pub const RESULTS_OK: gtk::ResponseType = gtk::ResponseType::Ok;
#[cfg(unix)]
#[deprecated(since="0.14.6", note="Please use `DR_CANCEL` instead")]
/// If the Cancel button in the dialog is pressed
pub const RESULTS_CANCEL: gtk::ResponseType = gtk::ResponseType::Cancel;

#[cfg(windows)]
/// If the YES button in the dialog is pressed
pub const DR_YES: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_RESULT =
    windows_sys::Win32::UI::WindowsAndMessaging::IDYES;
#[cfg(windows)]
/// If the NO button in the dialog is pressed
pub const DR_NO: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_RESULT =
    windows_sys::Win32::UI::WindowsAndMessaging::IDNO;
#[cfg(windows)]
/// If the OK button in the dialog is pressed
pub const DR_OK: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_RESULT =
    windows_sys::Win32::UI::WindowsAndMessaging::IDOK;
#[cfg(windows)]
/// If the Cancel button in the dialog is pressed
pub const DR_CANCEL: windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_RESULT =
    windows_sys::Win32::UI::WindowsAndMessaging::IDCANCEL;

#[cfg(unix)]
/// If the YES button in the dialog is pressed
pub const DR_YES: gtk::ResponseType = gtk::ResponseType::Yes;
#[cfg(unix)]
/// If the NO button in the dialog is pressed
pub const DR_NO: gtk::ResponseType = gtk::ResponseType::No;
#[cfg(unix)]
/// If the OK button in the dialog is pressed
pub const DR_OK: gtk::ResponseType = gtk::ResponseType::Ok;
#[cfg(unix)]
/// If the Cancel button in the dialog is pressed
pub const DR_CANCEL: gtk::ResponseType = gtk::ResponseType::Cancel;

// Window Styles
#[cfg(windows)]
#[deprecated(since="0.14.6", note="Please use `WS_NORMAL` instead")]
/// Standard window
pub const WINDOWSTYLE_NORMAL: windows_sys::Win32::UI::WindowsAndMessaging::WINDOW_STYLE = windows_sys::Win32::UI::WindowsAndMessaging::WS_OVERLAPPEDWINDOW;
#[cfg(windows)]
#[deprecated(since="0.14.6", note="Please use `WS_ONLYEXIT` instead")]
/// A window with only a close button
pub const WINDOWSTYLE_ONLYEXIT: windows_sys::Win32::UI::WindowsAndMessaging::WINDOW_STYLE = windows_sys::Win32::UI::WindowsAndMessaging::WS_SYSMENU;

#[cfg(unix)]
#[deprecated(since="0.14.6", note="Please use `WS_NORMAL` instead")]
/// Standard window
pub const WINDOWSTYLE_NORMAL: gtk::WindowType = gtk::WindowType::Toplevel;
#[cfg(unix)]
#[deprecated(since="0.14.6", note="Please use `WS_ONLYEXIT` instead")]
/// A window with only a close button
pub const WINDOWSTYLE_NOCAPTION: gtk::WindowType = gtk::WindowType::Popup;

// Window Styles
#[cfg(windows)]
/// Standard window
pub const WS_NORMAL: windows_sys::Win32::UI::WindowsAndMessaging::WINDOW_STYLE = windows_sys::Win32::UI::WindowsAndMessaging::WS_OVERLAPPEDWINDOW;
#[cfg(windows)]
/// A window with only a close button
pub const WS_ONLYEXIT: windows_sys::Win32::UI::WindowsAndMessaging::WINDOW_STYLE = windows_sys::Win32::UI::WindowsAndMessaging::WS_SYSMENU;

#[cfg(unix)]
/// Standard window
pub const WS_NORMAL: gtk::WindowType = gtk::WindowType::Toplevel;
#[cfg(unix)]
/// A window with only a close button
pub const WS_NOCAPTION: gtk::WindowType = gtk::WindowType::Popup;

#[cfg(windows)]
#[deprecated(since="0.14.6", note="Please use `AWS_UTILITY` instead")]
pub const ADVANCED_WINDOWSTYLE_UTILITY: windows_sys::Win32::UI::WindowsAndMessaging::WINDOW_EX_STYLE = windows_sys::Win32::UI::WindowsAndMessaging::WS_EX_TOOLWINDOW;
#[cfg(unix)]
#[deprecated(since="0.14.6", note="Please use `AWS_UTILITY` instead")]
pub const ADVANCED_WINDOWSTYLE_UTILITY: gtk::gdk::WindowTypeHint = gtk::gdk::WindowTypeHint::Utility;

#[cfg(windows)]
pub const AWS_UTILITY: windows_sys::Win32::UI::WindowsAndMessaging::WINDOW_EX_STYLE = windows_sys::Win32::UI::WindowsAndMessaging::WS_EX_TOOLWINDOW;
#[cfg(unix)]
pub const AWS_UTILITY: gtk::gdk::WindowTypeHint = gtk::gdk::WindowTypeHint::Utility;

/// File Chooser Attributes
pub const FC_NONE:winapi::shared::minwindef::DWORD = 0;
pub const FC_DISABLE_READ_ONLY:winapi::shared::minwindef::DWORD = winapi::um::commdlg::OFN_HIDEREADONLY;
/// Windows Only
pub const FC_NEW_EXPLORER:winapi::shared::minwindef::DWORD = winapi::um::commdlg::OFN_EXPLORER;
pub const FC_ENABLE_HELP:winapi::shared::minwindef::DWORD = winapi::um::commdlg::OFN_SHOWHELP;
