//! Used to store and read data.

use std::fs;
use std::path::PathBuf;
use platform_dirs::AppDirs;

pub struct Storage {
    app_dirs: AppDirs
}

impl Storage {

    /// Create a new Storage
    /// It will also create a directory based on the AppDirs argument.
    pub fn new(app_dirs: AppDirs) -> Self {
        Self {
            app_dirs
        }
    }

    pub fn create_app_dir(&self) {
        match self.app_dirs.config_dir.exists() {
            true => {}
            false => {
                match fs::create_dir(self.app_dirs.config_dir.clone()) {
                    Err(e) => panic!("{}: {}", self.app_dirs.config_dir.clone().to_str().unwrap(), e),
                    Ok(_) => 0,
                };
            }
        }
        match self.app_dirs.cache_dir.exists() {
            true => {}
            false => {
                match fs::create_dir(self.app_dirs.cache_dir.clone()) {
                    Err(e) => panic!("{}: {}", self.app_dirs.cache_dir.clone().to_str().unwrap(), e),
                    Ok(_) => 0,
                };
            }
        }
        match self.app_dirs.data_dir.exists() {
            true => {}
            false => {
                match fs::create_dir(self.app_dirs.data_dir.clone()) {
                    Err(e) => panic!("{}: {}", self.app_dirs.data_dir.clone().to_str().unwrap(), e),
                    Ok(_) => 0,
                };
            }
        }
    }

    /// Returns the cache_dir
    pub fn get_cache_dir(self) -> PathBuf {
        self.app_dirs.cache_dir
    }

    /// Returns the config_dir
    pub fn get_config_dir(self) -> PathBuf {
        self.app_dirs.config_dir
    }

    /// Returns the state_dir
    pub fn get_state_dir(self) -> PathBuf {
        self.app_dirs.state_dir
    }

    /// Returns the data_dir
    pub fn get_data_dir(self) -> PathBuf {
        self.app_dirs.data_dir
    }
}
