use crate::io::storage::Storage;
use crate::natives_and_messaging::*;
use crate::window::{Application, Frame, Attributes};

pub struct DemoWindow {

}

impl DemoWindow {
    pub fn new() -> Self {
        Self {

        }
    }
}

impl Application for DemoWindow {
    fn app_name(&self) -> String {
        "Demo Application".to_string()
    }

    fn attributes(&self) -> Attributes {
        Attributes::new(WINDOWSTYLE_NORMAL, "NXUI Window".to_string(),1280, 750, 100, 100)
    }

    fn is_child_window(&self) -> bool {
        false
    }

    fn startup(&self,storage: Storage) {
        println!("Startup!");
        println!("Config dir is {}",storage.get_config_dir().as_os_str().to_str().unwrap());
    }

    fn ui(&self,frame: Frame) {
        frame.show();
    }

    fn exit(&self) {
        println!("Exit Application");
    }
}