//! Provides tools for file manipulation

pub mod storage;

use std::fs::OpenOptions;
use std::io;
use std::path::Path;
use platform_dirs::AppDirs;

/// Returns app_dirs.
pub fn get_app_dirs(app_name: String) -> AppDirs {
    AppDirs::new(Some(&*app_name), false).unwrap()
}

pub fn touch(path: &Path) -> io::Result<()> {
    match OpenOptions::new().create(true).write(true).open(path) {
        Ok(_) => Ok(()),
        Err(e) => Err(e),
    }
}