use nxui::io::storage::Storage;
use nxui::natives_and_messaging::{ADVANCED_WINDOWSTYLE_UTILITY, WINDOWSTYLE_NORMAL};
use nxui::window::{AdvancedOptions, Application, Frame, WindowAttributes};

fn main() {
    let app = UtilityApplication::new();
    nxui::nxui::create_new_app(Box::new(app));
}

struct UtilityApplication {

}

impl UtilityApplication {
    pub fn new() -> Self {
        Self {

        }
    }
}

impl Application for UtilityApplication {
    fn app_name(&self) -> String {
        "Utility App".to_string()
    }

    fn attributes(&self) -> WindowAttributes {
        WindowAttributes::new(WINDOWSTYLE_NORMAL, "Utility Window".to_string(),400, 675, 100, 100,false)
    }

    fn advanced_options(&self) -> AdvancedOptions {
        AdvancedOptions::new(ADVANCED_WINDOWSTYLE_UTILITY)
    }

    fn ui(&self, frame: Frame) {
        frame.show();
    }
}