use crate::io::storage::Storage;
use crate::messagebox::MessageBox;
use crate::natives_and_messaging::*;
use crate::window::{Application, Frame, WindowAttributes};

pub struct DemoWindow {

}

impl DemoWindow {
    pub fn new() -> Self {
        Self {

        }
    }
}

impl Application for DemoWindow {
    fn app_name(&self) -> String {
        "Demo Application".to_string()
    }

    fn attributes(&self) -> WindowAttributes {
        WindowAttributes::new(WINDOWSTYLE_NORMAL, "NXUI Window".to_string(),1280, 750, 100, 100,false)
    }

    fn startup(&self,storage: Storage) {
        println!("Startup!");
        println!("Config dir is {}",storage.get_config_dir().as_os_str().to_str().unwrap());
    }

    fn ui(&self,frame: Frame) {
        frame.show();
        match MessageBox::new("Do you want to maximize the window?".to_string(), "Do you want to maximize the window?".to_string(), DIALOGSTYLE_QUESTION, BUTTONSTYLE_YESNO).show(Frame::default()) {
            RESULTS_YES => {
                frame.show_maximized();
                frame.set_title("The window has been maximized.".to_string());
            }

            RESULTS_NO => {
                frame.show_minimized();
                frame.set_title("The window has been minimized.".to_string());
            }

            _ => {}
        }
        frame.set_size(500,720);
    }

    fn exit(&self) {
        println!("Exit Application");
    }
}