use windows_sys::{
    Win32::Foundation::*, Win32::Graphics::Gdi::ValidateRect,
    Win32::System::LibraryLoader::GetModuleHandleA, Win32::UI::WindowsAndMessaging::*,
};

#[cfg(windows)]
pub struct Window {
    pub classname: PSTR,
    pub title: String,
    pub width: i32,
    pub height: i32,
    pub x: i32,
    pub y: i32
}

impl Window {
    #[cfg(windows)]
    pub fn show(&self,window_style: WINDOW_STYLE,application_id: &str) {
        extern "system" fn wndproc(window: HWND, message: u32, wparam: WPARAM, lparam: LPARAM) -> LRESULT {
            unsafe {
                match message as u32 {
                    WM_PAINT => {
                        println!("WM_PAINT");
                        ValidateRect(window, std::ptr::null());
                        0
                    }
                    WM_DESTROY => {
                        println!("WM_DESTROY");
                        PostQuitMessage(0);
                        0
                    }
                    _ => DefWindowProcA(window, message, wparam, lparam),
                }
            }
        }
        unsafe {
            let instance = GetModuleHandleA(std::ptr::null_mut());
            debug_assert!(instance != 0);

            let wc = WNDCLASSA {
                hCursor: LoadCursorW(0, IDC_ARROW),
                hInstance: instance,
                lpszClassName: self.classname,
                style: CS_HREDRAW | CS_VREDRAW,
                lpfnWndProc: Some(wndproc),
                cbClsExtra: 0,
                cbWndExtra: 0,
                hIcon: 0,
                hbrBackground: 0,
                lpszMenuName: std::ptr::null_mut(),
            };

            let atom = RegisterClassA(&wc);
            debug_assert!(atom != 0);

            CreateWindowExA(
                0,
                self.classname,
                self.title.as_ptr() as _,
                WS_VISIBLE | window_style,
                CW_USEDEFAULT,
                CW_USEDEFAULT,
                self.width,
                self.height,
                0,
                0,
                instance,
                std::ptr::null_mut(),
            );

            let mut message = std::mem::zeroed();

            while GetMessageA(&mut message, 0, 0, 0) != 0 {
                DispatchMessageA(&mut message);
            }
        }
    }

    #[cfg(linux)]
    pub fn show(&self,window_style: WINDOW_STYLE,application_id: &str) {
        use gtk::prelude::*;

        fn build_ui(application: &gtk::Application) {
            let window = gtk::ApplicationWindow::new(application);

            window.set_title(&*self.title);
            window.set_border_width(10);
            window.set_position(gtk::WindowPosition::Center);
            window.set_default_size(self.width, self.height);

            window.show_all();
        }

        let application =
            gtk::Application::new(Some(application_id), Default::default());

        application.connect_activate(build_ui);

        application.run();
    }
}