#[cfg(windows)]
use windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE;
#[cfg(linux)]
use gtk::prelude::*;
use windows_sys::Win32::Foundation::PSTR;
use windows_sys::Win32::UI::WindowsAndMessaging::WINDOW_STYLE;

// Default

#[cfg(windows)]
pub const DEFAULT_WINDOW_WIDTH: i32 = 1280;
#[cfg(windows)]
pub const DEFAULT_WINDOW_HEIGHT: i32 = 720;
#[cfg(windows)]
pub const DEFAULT_WINDOW_X: i32 = 500;
#[cfg(windows)]
pub const DEFAULT_WINDOW_Y: i32 = 500;
#[cfg(windows)]
pub const DEFAULT_WINDOW_WINDOW_CLASS: PSTR = b"window\0".as_ptr() as _;

// Button Styles

#[cfg(windows)]
pub const BUTTONSTYLE_OK: MESSAGEBOX_STYLE = 0u32;
#[cfg(linux)]
pub const BUTTONSTYLE_OK: ButtonsType = gtk::ButtonsType::Ok;

// Dialog Styles

#[cfg(windows)]
pub const DIALOGSTYLE_NONE: MESSAGEBOX_STYLE = 0;
#[cfg(linux)]
pub const DIALOGSTYLE_NONE: MessageType = gtk::MessageType::Other;

#[cfg(windows)]
pub const DIALOGSTYLE_INFO: MESSAGEBOX_STYLE = 64u32;
#[cfg(linux)]
pub const DIALOGSTYLE_NONE: MessageType = gtk::MessageType::Info;

#[cfg(windows)]
pub const DIALOGSTYLE_QUESTION: MESSAGEBOX_STYLE = 32u32;
#[cfg(linux)]
pub const DIALOGSTYLE_NONE: MessageType = gtk::MessageType::Question;

#[cfg(windows)]
pub const DIALOGSTYLE_EXCLAMATION: MESSAGEBOX_STYLE = 48u32;
#[cfg(linux)]
pub const DIALOGSTYLE_NONE: MessageType = gtk::MessageType::Warning;

#[cfg(windows)]
pub const DIALOGSTYLE_ERROR: MESSAGEBOX_STYLE = 16u32;
#[cfg(linux)]
pub const DIALOGSTYLE_NONE: MessageType = gtk::MessageType::ERROR;

// Dialog hints

#[cfg(windows)]
pub const DIALOGHINT_MODAL: u64 = 0;
#[cfg(linux)]
pub const DIALOGHINT_MODAL: gtk::DialogFlags = gtk::DialogFlags::MODAL;

// Window Styles

#[cfg(windows)]
pub const WINDOWSTYLE_OVERLAPPED: WINDOW_STYLE = 13565952u32;

#[cfg(windows)]
pub const WINDOWSTYLE_POPUP: WINDOW_STYLE = 2147483648u32;

#[cfg(windows)]
pub const WINDOWSTYLE_CHILD: WINDOW_STYLE = 1073741824u32;

#[cfg(windows)]
pub const WINDOWSTYLE_MINIMIZE: WINDOW_STYLE = 536870912u32;

#[cfg(windows)]
pub const WINDOWSTYLE_DISABLED: WINDOW_STYLE = 134217728u32;

#[cfg(windows)]
pub const WINDOWSTYLE_MAXIMIZE: WINDOW_STYLE = 16777216u32;

#[cfg(windows)]
pub const WINDOWSTYLE_CAPTION: WINDOW_STYLE = 12582912u32;

#[cfg(windows)]
pub const WINDOWSTYLE_SYSMENU: WINDOW_STYLE = 524288u32;

#[cfg(windows)]
pub const WINDOWSTYLE_VSCROLL: WINDOW_STYLE = 2097152u32;

#[cfg(windows)]
pub const WINDOWSTYLE_SIZEBOX: WINDOW_STYLE = 262144u32;