use windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE;

pub struct MessageBox {
    pub title: String,
    pub message: String
}

impl MessageBox {
    pub fn get_title(&self) -> &str {
        &self.title
    }

    pub fn get_message(&self) -> &str {
        &self.message
    }

    /// Display the dialog
    ///
    /// # Examples
    ///
    /// ```
    /// use windows_sys::Win32::UI::WindowsAndMessaging::*;
    /// use nxui::messagebox;
    /// use nxui::NativesAndMessaging::*;
    ///
    /// fn main() {
    ///     let msg_box = messagebox::MessageBox { title: "This is a test".to_string().parse().unwrap(), message: "Hello World".to_string().parse().unwrap() };
    ///     msg_box.show(BUTTONSTYLE_OK,WINDOWSTYLE_MODAL);
    /// }
    /// ```
    #[cfg(windows)]
    pub fn show(&self,button_type: MESSAGEBOX_STYLE,window_style: u64) {
        use windows_sys::{
            Win32::Foundation::*, Win32::System::Threading::*, Win32::UI::WindowsAndMessaging::*,
        };
        unsafe {
            let event = CreateEventW(std::ptr::null(), 1, 0, std::ptr::null());
            SetEvent(event);
            WaitForSingleObject(event, 0);
            CloseHandle(event);

            MessageBoxA(window_style.try_into().unwrap(), self.message.as_ptr(), self.title.as_ptr(), button_type);
        }
    }
    #[cfg(linux)]
    pub fn show(&self,button_type: ButtonsType,window_style: DialogFlags) {
        use gtk::prelude::*;
        let dialog = gtk::MessageDialog::new(
            Some(&window_),
            window_style,
            gtk::MessageType::Info,
            button_type
            &message
        );
        dialog.run();
        dialog.destroy();
    }
}