use windows_sys::Win32::UI::WindowsAndMessaging::MESSAGEBOX_STYLE;

pub struct MessageBox {
    pub title: String,
    pub message: String
}

impl MessageBox {
    pub fn get_title(&self) -> &str {
        &self.title
    }

    pub fn get_message(&self) -> &str {
        &self.message
    }

    #[cfg(windows)]
    /// Display the dialog
    ///
    /// # Examples
    ///
    /// ```
    /// use windows_sys::Win32::UI::WindowsAndMessaging::*;
    /// use nxui::messagebox;
    ///
    /// fn main() {
    ///     let msg_box = messagebox::MessageBox { title: "This is a test".to_string().parse().unwrap(), message: "Hello World".to_string().parse().unwrap() };
    ///     msg_box.show(MB_OK);
    /// }
    /// ```
    pub fn show(&self,button_type: MESSAGEBOX_STYLE) {
        use windows_sys::{
            Win32::Foundation::*, Win32::System::Threading::*, Win32::UI::WindowsAndMessaging::*,
        };
        unsafe {
            let event = CreateEventW(std::ptr::null(), 1, 0, std::ptr::null());
            SetEvent(event);
            WaitForSingleObject(event, 0);
            CloseHandle(event);

            MessageBoxA(0, self.message.as_ptr(), self.title.as_ptr(), MB_OK);
        }
    }
}