use super::schema::{block_properties, blocks};
use std::hash::{Hash, Hasher};

#[derive(Queryable, Insertable, Identifiable)]
#[primary_key(block_id, name)]
#[table_name = "block_properties"]
pub struct BlockProperty {
    pub block_id: Vec<u8>,
    pub name: String,
    pub data: Vec<u8>,
}

#[derive(Queryable, Insertable)]
#[table_name = "blocks"]
pub struct Block {
    pub id: Vec<u8>,
    pub rank: String,
    pub type_: String,
}

impl PartialEq for Block {
    fn eq(&self, other: &Self) -> bool {
        self.id == other.id
    }
}

impl Eq for Block {}

impl Hash for Block {
    fn hash<H: Hasher>(&self, state: &mut H) {
        state.write(&self.id);
    }
}
