//! Raw bindings to libnvvm. All APIs are exposed safely so this module should generally not be used.

// generated by bindgen

pub const nvvmResult_NVVM_SUCCESS: nvvmResult = 0;
pub const nvvmResult_NVVM_ERROR_OUT_OF_MEMORY: nvvmResult = 1;
pub const nvvmResult_NVVM_ERROR_PROGRAM_CREATION_FAILURE: nvvmResult = 2;
pub const nvvmResult_NVVM_ERROR_IR_VERSION_MISMATCH: nvvmResult = 3;
pub const nvvmResult_NVVM_ERROR_INVALID_INPUT: nvvmResult = 4;
pub const nvvmResult_NVVM_ERROR_INVALID_PROGRAM: nvvmResult = 5;
pub const nvvmResult_NVVM_ERROR_INVALID_IR: nvvmResult = 6;
pub const nvvmResult_NVVM_ERROR_INVALID_OPTION: nvvmResult = 7;
pub const nvvmResult_NVVM_ERROR_NO_MODULE_IN_PROGRAM: nvvmResult = 8;
pub const nvvmResult_NVVM_ERROR_COMPILATION: nvvmResult = 9;

#[doc = " \\ingroup error"]
#[doc = " \\brief   NVVM API call result code."]
pub type nvvmResult = ::std::os::raw::c_int;
extern "C" {
    #[doc = " \\ingroup error"]
    #[doc = " \\brief   Get the message string for the given #nvvmResult code."]
    #[doc = ""]
    #[doc = " \\param   [in] result NVVM API result code."]
    #[doc = " \\return  Message string for the given #nvvmResult code."]
    pub fn nvvmGetErrorString(result: nvvmResult) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " \\ingroup query"]
    #[doc = " \\brief   Get the NVVM version."]
    #[doc = ""]
    #[doc = " \\param   [out] major NVVM major version number."]
    #[doc = " \\param   [out] minor NVVM minor version number."]
    #[doc = " \\return"]
    #[doc = "   - \\link ::nvvmResult NVVM_SUCCESS \\endlink"]
    #[doc = ""]
    pub fn nvvmVersion(
        major: *mut ::std::os::raw::c_int,
        minor: *mut ::std::os::raw::c_int,
    ) -> nvvmResult;
}
extern "C" {
    #[doc = " \\ingroup query"]
    #[doc = " \\brief   Get the NVVM IR version."]
    #[doc = ""]
    #[doc = " \\param   [out] majorIR  NVVM IR major version number."]
    #[doc = " \\param   [out] minorIR  NVVM IR minor version number."]
    #[doc = " \\param   [out] majorDbg NVVM IR debug metadata major version number."]
    #[doc = " \\param   [out] minorDbg NVVM IR debug metadata minor version number."]
    #[doc = " \\return"]
    #[doc = "   - \\link ::nvvmResult NVVM_SUCCESS \\endlink"]
    #[doc = ""]
    pub fn nvvmIRVersion(
        majorIR: *mut ::std::os::raw::c_int,
        minorIR: *mut ::std::os::raw::c_int,
        majorDbg: *mut ::std::os::raw::c_int,
        minorDbg: *mut ::std::os::raw::c_int,
    ) -> nvvmResult;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _nvvmProgram {
    _unused: [u8; 0],
}
#[doc = " \\ingroup compilation"]
#[doc = " \\brief   NVVM Program"]
#[doc = ""]
#[doc = " An opaque handle for a program"]
pub type nvvmProgram = *mut _nvvmProgram;
extern "C" {
    #[doc = " \\ingroup compilation"]
    #[doc = " \\brief   Create a program, and set the value of its handle to *prog."]
    #[doc = ""]
    #[doc = " \\param   [in] prog NVVM program."]
    #[doc = " \\return"]
    #[doc = "   - \\link ::nvvmResult NVVM_SUCCESS \\endlink"]
    #[doc = "   - \\link ::nvvmResult NVVM_ERROR_OUT_OF_MEMORY \\endlink"]
    #[doc = "   - \\link ::nvvmResult NVVM_ERROR_INVALID_PROGRAM \\endlink"]
    #[doc = ""]
    #[doc = " \\see     nvvmDestroyProgram()"]
    pub fn nvvmCreateProgram(prog: *mut nvvmProgram) -> nvvmResult;
}
extern "C" {
    #[doc = " \\ingroup compilation"]
    #[doc = " \\brief   Destroy a program."]
    #[doc = ""]
    #[doc = " \\param    [in] prog NVVM program."]
    #[doc = " \\return"]
    #[doc = "   - \\link ::nvvmResult NVVM_SUCCESS \\endlink"]
    #[doc = "   - \\link ::nvvmResult NVVM_ERROR_INVALID_PROGRAM \\endlink"]
    #[doc = ""]
    #[doc = " \\see     nvvmCreateProgram()"]
    pub fn nvvmDestroyProgram(prog: *mut nvvmProgram) -> nvvmResult;
}
extern "C" {
    #[doc = " \\ingroup compilation"]
    #[doc = " \\brief   Add a module level NVVM IR to a program."]
    #[doc = ""]
    #[doc = " The buffer should contain an NVVM IR module."]
    #[doc = " The module should have NVVM IR version 1.6 either in the LLVM 7.0.1 bitcode"]
    #[doc = " representation or in the LLVM 7.0.1 text representation. Support for reading"]
    #[doc = " the text representation of NVVM IR is deprecated and may be removed in a"]
    #[doc = " later version."]
    #[doc = ""]
    #[doc = " \\param   [in] prog   NVVM program."]
    #[doc = " \\param   [in] buffer NVVM IR module in the bitcode or text"]
    #[doc = "                      representation."]
    #[doc = " \\param   [in] size   Size of the NVVM IR module."]
    #[doc = " \\param   [in] name   Name of the NVVM IR module."]
    #[doc = "                      If NULL, \"<unnamed>\" is used as the name."]
    #[doc = " \\return"]
    #[doc = "   - \\link ::nvvmResult NVVM_SUCCESS \\endlink"]
    #[doc = "   - \\link ::nvvmResult NVVM_ERROR_OUT_OF_MEMORY \\endlink"]
    #[doc = "   - \\link ::nvvmResult NVVM_ERROR_INVALID_INPUT \\endlink"]
    #[doc = "   - \\link ::nvvmResult NVVM_ERROR_INVALID_PROGRAM \\endlink"]
    pub fn nvvmAddModuleToProgram(
        prog: nvvmProgram,
        buffer: *const ::std::os::raw::c_char,
        size: size_t,
        name: *const ::std::os::raw::c_char,
    ) -> nvvmResult;
}
extern "C" {
    #[doc = " \\ingroup compilation"]
    #[doc = " \\brief   Add a module level NVVM IR to a program."]
    #[doc = ""]
    #[doc = " The buffer should contain an NVVM IR module. The module should have NVVM IR"]
    #[doc = " version 1.6 in LLVM 7.0.1 bitcode representation."]
    #[doc = ""]
    #[doc = " A module added using this API is lazily loaded - the only symbols loaded"]
    #[doc = " are those that are required by module(s) loaded using"]
    #[doc = " nvvmAddModuleToProgram. It is an error for a program to have"]
    #[doc = " all modules loaded using this API. Compiler may also optimize entities"]
    #[doc = " in this module by making them internal to the linked NVVM IR module,"]
    #[doc = " making them eligible for other optimizations. Due to these"]
    #[doc = " optimizations, this API to load a module is more efficient and should"]
    #[doc = " be used where possible."]
    #[doc = ""]
    #[doc = " \\param   [in] prog   NVVM program."]
    #[doc = " \\param   [in] buffer NVVM IR module in the bitcode representation."]
    #[doc = " \\param   [in] size   Size of the NVVM IR module."]
    #[doc = " \\param   [in] name   Name of the NVVM IR module."]
    #[doc = "                      If NULL, \"<unnamed>\" is used as the name."]
    #[doc = " \\return"]
    #[doc = "   - \\link ::nvvmResult NVVM_SUCCESS \\endlink"]
    #[doc = "   - \\link ::nvvmResult NVVM_ERROR_OUT_OF_MEMORY \\endlink"]
    #[doc = "   - \\link ::nvvmResult NVVM_ERROR_INVALID_INPUT \\endlink"]
    #[doc = "   - \\link ::nvvmResult NVVM_ERROR_INVALID_PROGRAM \\endlink"]
    pub fn nvvmLazyAddModuleToProgram(
        prog: nvvmProgram,
        buffer: *const ::std::os::raw::c_char,
        size: size_t,
        name: *const ::std::os::raw::c_char,
    ) -> nvvmResult;
}
extern "C" {
    #[doc = " \\ingroup compilation"]
    #[doc = " \\brief   Compile the NVVM program."]
    #[doc = ""]
    #[doc = " The NVVM IR modules in the program will be linked at the IR level."]
    #[doc = " The linked IR program is compiled to PTX."]
    #[doc = ""]
    #[doc = " The target datalayout in the linked IR program is used to"]
    #[doc = " determine the address size (32bit vs 64bit)."]
    #[doc = ""]
    #[doc = " The valid compiler options are:"]
    #[doc = ""]
    #[doc = "   - -g (enable generation of debugging information, valid only with -opt=0)"]
    #[doc = "   - -generate-line-info (generate line number information)"]
    #[doc = "   - -opt="]
    #[doc = "     - 0 (disable optimizations)"]
    #[doc = "     - 3 (default, enable optimizations)"]
    #[doc = "   - -arch="]
    #[doc = "     - compute_35"]
    #[doc = "     - compute_37"]
    #[doc = "     - compute_50"]
    #[doc = "     - compute_52 (default)"]
    #[doc = "     - compute_53"]
    #[doc = "     - compute_60"]
    #[doc = "     - compute_61"]
    #[doc = "     - compute_62"]
    #[doc = "     - compute_70"]
    #[doc = "     - compute_72"]
    #[doc = "     - compute_75"]
    #[doc = "     - compute_80"]
    #[doc = "   - -ftz="]
    #[doc = "     - 0 (default, preserve denormal values, when performing"]
    #[doc = "          single-precision floating-point operations)"]
    #[doc = "     - 1 (flush denormal values to zero, when performing"]
    #[doc = "          single-precision floating-point operations)"]
    #[doc = "   - -prec-sqrt="]
    #[doc = "     - 0 (use a faster approximation for single-precision"]
    #[doc = "          floating-point square root)"]
    #[doc = "     - 1 (default, use IEEE round-to-nearest mode for"]
    #[doc = "          single-precision floating-point square root)"]
    #[doc = "   - -prec-div="]
    #[doc = "     - 0 (use a faster approximation for single-precision"]
    #[doc = "          floating-point division and reciprocals)"]
    #[doc = "     - 1 (default, use IEEE round-to-nearest mode for"]
    #[doc = "          single-precision floating-point division and reciprocals)"]
    #[doc = "   - -fma="]
    #[doc = "     - 0 (disable FMA contraction)"]
    #[doc = "     - 1 (default, enable FMA contraction)"]
    #[doc = ""]
    #[doc = " \\param   [in] prog       NVVM program."]
    #[doc = " \\param   [in] numOptions Number of compiler options passed."]
    #[doc = " \\param   [in] options    Compiler options in the form of C string array."]
    #[doc = " \\return"]
    #[doc = "   - \\link ::nvvmResult NVVM_SUCCESS \\endlink"]
    #[doc = "   - \\link ::nvvmResult NVVM_ERROR_OUT_OF_MEMORY \\endlink"]
    #[doc = "   - \\link ::nvvmResult NVVM_ERROR_IR_VERSION_MISMATCH \\endlink"]
    #[doc = "   - \\link ::nvvmResult NVVM_ERROR_INVALID_PROGRAM \\endlink"]
    #[doc = "   - \\link ::nvvmResult NVVM_ERROR_INVALID_OPTION \\endlink"]
    #[doc = "   - \\link ::nvvmResult NVVM_ERROR_NO_MODULE_IN_PROGRAM \\endlink"]
    #[doc = "   - \\link ::nvvmResult NVVM_ERROR_COMPILATION \\endlink"]
    pub fn nvvmCompileProgram(
        prog: nvvmProgram,
        numOptions: ::std::os::raw::c_int,
        options: *mut *const ::std::os::raw::c_char,
    ) -> nvvmResult;
}
extern "C" {
    #[doc = " \\ingroup compilation"]
    #[doc = " \\brief   Verify the NVVM program."]
    #[doc = ""]
    #[doc = " The valid compiler options are:"]
    #[doc = ""]
    #[doc = " Same as for nvvmCompileProgram()."]
    #[doc = ""]
    #[doc = " \\param   [in] prog       NVVM program."]
    #[doc = " \\param   [in] numOptions Number of compiler options passed."]
    #[doc = " \\param   [in] options    Compiler options in the form of C string array."]
    #[doc = " \\return"]
    #[doc = "   - \\link ::nvvmResult NVVM_SUCCESS \\endlink"]
    #[doc = "   - \\link ::nvvmResult NVVM_ERROR_OUT_OF_MEMORY \\endlink"]
    #[doc = "   - \\link ::nvvmResult NVVM_ERROR_IR_VERSION_MISMATCH \\endlink"]
    #[doc = "   - \\link ::nvvmResult NVVM_ERROR_INVALID_PROGRAM \\endlink"]
    #[doc = "   - \\link ::nvvmResult NVVM_ERROR_INVALID_IR \\endlink"]
    #[doc = "   - \\link ::nvvmResult NVVM_ERROR_INVALID_OPTION \\endlink"]
    #[doc = "   - \\link ::nvvmResult NVVM_ERROR_NO_MODULE_IN_PROGRAM \\endlink"]
    #[doc = ""]
    #[doc = " \\see     nvvmCompileProgram()"]
    pub fn nvvmVerifyProgram(
        prog: nvvmProgram,
        numOptions: ::std::os::raw::c_int,
        options: *mut *const ::std::os::raw::c_char,
    ) -> nvvmResult;
}
extern "C" {
    #[doc = " \\ingroup compilation"]
    #[doc = " \\brief   Get the size of the compiled result."]
    #[doc = ""]
    #[doc = " \\param   [in]  prog          NVVM program."]
    #[doc = " \\param   [out] bufferSizeRet Size of the compiled result (including the"]
    #[doc = "                              trailing NULL)."]
    #[doc = " \\return"]
    #[doc = "   - \\link ::nvvmResult NVVM_SUCCESS \\endlink"]
    #[doc = "   - \\link ::nvvmResult NVVM_ERROR_INVALID_PROGRAM \\endlink"]
    pub fn nvvmGetCompiledResultSize(prog: nvvmProgram, bufferSizeRet: *mut size_t) -> nvvmResult;
}
extern "C" {
    #[doc = " \\ingroup compilation"]
    #[doc = " \\brief   Get the compiled result."]
    #[doc = ""]
    #[doc = " The result is stored in the memory pointed by 'buffer'."]
    #[doc = ""]
    #[doc = " \\param   [in]  prog   NVVM program."]
    #[doc = " \\param   [out] buffer Compiled result."]
    #[doc = " \\return"]
    #[doc = "   - \\link ::nvvmResult NVVM_SUCCESS \\endlink"]
    #[doc = "   - \\link ::nvvmResult NVVM_ERROR_INVALID_PROGRAM \\endlink"]
    pub fn nvvmGetCompiledResult(
        prog: nvvmProgram,
        buffer: *mut ::std::os::raw::c_char,
    ) -> nvvmResult;
}
extern "C" {
    #[doc = " \\ingroup compilation"]
    #[doc = " \\brief   Get the Size of Compiler/Verifier Message."]
    #[doc = ""]
    #[doc = " The size of the message string (including the trailing NULL) is stored into"]
    #[doc = " 'buffer_size_ret' when the return value is NVVM_SUCCESS."]
    #[doc = ""]
    #[doc = " \\param   [in]  prog          NVVM program."]
    #[doc = " \\param   [out] bufferSizeRet Size of the compilation/verification log"]
    #[doc = "(including the trailing NULL)."]
    #[doc = " \\return"]
    #[doc = "   - \\link ::nvvmResult NVVM_SUCCESS \\endlink"]
    #[doc = "   - \\link ::nvvmResult NVVM_ERROR_INVALID_PROGRAM \\endlink"]
    pub fn nvvmGetProgramLogSize(prog: nvvmProgram, bufferSizeRet: *mut size_t) -> nvvmResult;
}
extern "C" {
    #[doc = " \\ingroup compilation"]
    #[doc = " \\brief   Get the Compiler/Verifier Message"]
    #[doc = ""]
    #[doc = " The NULL terminated message string is stored in the memory pointed by"]
    #[doc = " 'buffer' when the return value is NVVM_SUCCESS."]
    #[doc = ""]
    #[doc = " \\param   [in]  prog   NVVM program program."]
    #[doc = " \\param   [out] buffer Compilation/Verification log."]
    #[doc = " \\return"]
    #[doc = "   - \\link ::nvvmResult NVVM_SUCCESS \\endlink"]
    #[doc = "   - \\link ::nvvmResult NVVM_ERROR_INVALID_PROGRAM \\endlink"]
    pub fn nvvmGetProgramLog(prog: nvvmProgram, buffer: *mut ::std::os::raw::c_char) -> nvvmResult;
}
pub type size_t = ::std::os::raw::c_ulonglong;
