extern crate async_std;
extern crate js_sys;
extern crate kagura;
extern crate wasm_bindgen;
extern crate wasm_bindgen_futures;
extern crate web_sys;

pub mod dom_events;
pub mod dom_node;
pub mod dom_renderer;
pub mod html;
pub mod html_component;
pub mod html_node;
pub mod html_prefab;
pub mod html_renderer;
pub mod util;
pub mod v_node;

pub use dom_events::DomEvents;
pub use dom_renderer::DomRenderer;
pub use html::Html;
pub use html_component::HtmlComponent;
pub use html_node::HtmlNode;
pub use html_prefab::HtmlPrefab;
pub use html_renderer::HtmlRenderer;
pub use v_node::VNode;

pub mod prelude {
    pub use crate::html::html_element::{Attributes, Events};
    pub use crate::html_component::Sub;
    pub use crate::{Html, HtmlComponent};
    pub use std::pin::Pin;
}
