//!A simple library for elementary number theory and arbitrary precision arithmetic. 


pub mod traits;
pub mod byte;
pub mod twobytes;
pub mod fourbytes;
pub mod eightbytes;
pub mod sixteenbytes;   
    mod fjprime32;
    mod fjprime64;
    mod primes;
    
    // computational speed 193.483187015s for primality checks in the interval [0;10^9]
 pub mod arithmetic;
    
 pub   use crate::traits::NumberTheory;
 pub   use crate::arithmetic::mpz::Mpz;
 pub   use crate::arithmetic::sign::Sign;

  // 203280221primes counted in 565.992596603s
  // 190335585primes counted in 1889.915528202s         
  // 369323305primes counted in 4801.997877603s

  // 717267168primes counted in 10829.221594857s
  //1394192236primes counted in 21654.235777474s
  
 // Running Count        Time
 //   1480206279          18087.12s   for 0;2^34 
 
 
 



