Currently the fastest library for factorization and primality checking in the interval 0;2^64 that is available in Crates.io and possibly in the entire Rust-lang ecosystem. Algebraic definitions of primality and factorization are used, permitting checks like -127.is_prime() to return true and unique factorizations to be considered unsigned.

Note that this current implementation requires compiler optimizations to be on for primality testing and consequently nearly all functionality. 

Currently implements these functions

- Primality
- Factorization
- Euler totient
- Integer radical (not sqrt)
- K-free
- Modular exponentiation and quadratic residues

Future updates will expand the datatypes supported to include 128-bit integers (becoming one of the few libraries that do) and additional functions like Jacobi, Mangoldt, prime-counting and modular sqrt. 
