use crate::nucleon::{NucleonConfig, NucleonInfo, NucleonState};
use serde::{Deserialize, Serialize};

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum SystemRequest {
    ListRegisteredNucleons,
    ListNucleonInstances,
    AddNucleon(NucleonConfig, NucleonInfo),
    DeleteNucleon(String),
    SetNucleonState(String, NucleonState),
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum SystemReply {
    Success,
    Error(String),
    ListRegisteredNucleons(Vec<NucleonInfo>),
    ListNucleonInstances(Vec<NucleonConfig>),
}
