use serde::{Deserialize, Serialize};
use std::collections::HashMap;
use std::fmt::Formatter;

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum NucleonRequest {
    Ping,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum NucleonReply {
    Pong,
    Succes,
    Error(String),
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum Capability {
    Interface,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub struct PropertyDescription {
    pub name: String,
    pub display_name: String,
    pub description: String,
    pub default_value: serde_json::Value,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub enum NucleonState {
    Initial,
    Inited,
    Stopped,
    Started,
}

impl std::fmt::Display for NucleonState {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "{}",
            match self {
                NucleonState::Initial => {
                    "Initial"
                }
                NucleonState::Inited => {
                    "Inited"
                }
                NucleonState::Stopped => {
                    "Stopped"
                }
                NucleonState::Started => {
                    "Started"
                }
            }
        )
    }
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub struct NucleonInfo {
    pub properties: Vec<PropertyDescription>,
    #[serde(skip_serializing_if = "String::is_empty")]
    #[serde(default)]
    pub type_name: String,
    pub capabilities: Vec<Capability>,
}

#[derive(Clone, Debug, Serialize, Deserialize)]
pub struct NucleonConfig {
    pub properties: Properties,
    pub nucleon_name: String,
}

pub type Properties = HashMap<String, serde_json::Value>;
pub type NucleonConfigs = HashMap<String, Vec<NucleonConfig>>;
