use serde::{Deserialize, Serialize};

use nucleon::exports::*;

#[derive(Debug, Serialize, Deserialize)]
pub struct NucleusConfig {
    pub nucleons: NucleonConfigs,
    pub nucleon_path: String,
}

impl NucleusConfig {
    pub fn new() -> Self {
        Self {
            nucleons: NucleonConfigs::new(),
            nucleon_path: "./".to_string(),
        }
    }
}
