# from toml

Converts toml data into table. Use this when nushell cannot determine the input file extension.

## Example

Let's say we have the following Rust .lock file:

```shell
> open Cargo.lock
# This file is automatically @generated by Cargo.
# It is not intended for manual editing.                                   [[package]]                                                                name = "adler32"                                                           version = "1.0.3"                                                          source = "registry+https://github.com/rust-lang/crates.io-index"
...
```

The "Cargo.lock" file is actually a .toml file, but the file extension isn't .toml. That's okay, we can use the `from toml` command:

```shell
> open Cargo.lock | from toml
─────────┬──────────────────
 package │ [table 459 rows]
─────────┴──────────────────
```
