#ifndef NSTD_INPUT_KEY_H_INCLUDED
#define NSTD_INPUT_KEY_H_INCLUDED
#include "../core/def.h"
#define NSTD_INPUT_KEY_SHIFT_BIT 0b00000001
#define NSTD_INPUT_KEY_CTRL_BIT 0b00000010
#define NSTD_INPUT_KEY_ALT_BIT 0b00000100
#define NSTD_INPUT_KEY_LOGO_BIT 0b00001000

/// Represents a virtual key code.
typedef enum
{
    NSTD_KEY_NONE,
    NSTD_KEY_1,
    NSTD_KEY_2,
    NSTD_KEY_3,
    NSTD_KEY_4,
    NSTD_KEY_5,
    NSTD_KEY_6,
    NSTD_KEY_7,
    NSTD_KEY_8,
    NSTD_KEY_9,
    NSTD_KEY_0,
    NSTD_KEY_A,
    NSTD_KEY_B,
    NSTD_KEY_C,
    NSTD_KEY_D,
    NSTD_KEY_E,
    NSTD_KEY_F,
    NSTD_KEY_G,
    NSTD_KEY_H,
    NSTD_KEY_I,
    NSTD_KEY_J,
    NSTD_KEY_K,
    NSTD_KEY_L,
    NSTD_KEY_M,
    NSTD_KEY_N,
    NSTD_KEY_O,
    NSTD_KEY_P,
    NSTD_KEY_Q,
    NSTD_KEY_R,
    NSTD_KEY_S,
    NSTD_KEY_T,
    NSTD_KEY_U,
    NSTD_KEY_V,
    NSTD_KEY_W,
    NSTD_KEY_X,
    NSTD_KEY_Y,
    NSTD_KEY_Z,
    NSTD_KEY_ESCAPE,
    NSTD_KEY_F1,
    NSTD_KEY_F2,
    NSTD_KEY_F3,
    NSTD_KEY_F4,
    NSTD_KEY_F5,
    NSTD_KEY_F6,
    NSTD_KEY_F7,
    NSTD_KEY_F8,
    NSTD_KEY_F9,
    NSTD_KEY_F10,
    NSTD_KEY_F11,
    NSTD_KEY_F12,
    NSTD_KEY_F13,
    NSTD_KEY_F14,
    NSTD_KEY_F15,
    NSTD_KEY_F16,
    NSTD_KEY_F17,
    NSTD_KEY_F18,
    NSTD_KEY_F19,
    NSTD_KEY_F20,
    NSTD_KEY_F21,
    NSTD_KEY_F22,
    NSTD_KEY_F23,
    NSTD_KEY_F24,
    NSTD_KEY_SNAPSHOT,
    NSTD_KEY_SCROLL,
    NSTD_KEY_PAUSE,
    NSTD_KEY_INSERT,
    NSTD_KEY_HOME,
    NSTD_KEY_DELETE,
    NSTD_KEY_END,
    NSTD_KEY_PAGE_DOWN,
    NSTD_KEY_PAGE_UP,
    NSTD_KEY_LEFT,
    NSTD_KEY_UP,
    NSTD_KEY_RIGHT,
    NSTD_KEY_DOWN,
    NSTD_KEY_BACK,
    NSTD_KEY_RETURN,
    NSTD_KEY_SPACE,
    NSTD_KEY_COMPOSE,
    NSTD_KEY_CARET,
    NSTD_KEY_NUMLOCK,
    NSTD_KEY_NUMPAD_0,
    NSTD_KEY_NUMPAD_1,
    NSTD_KEY_NUMPAD_2,
    NSTD_KEY_NUMPAD_3,
    NSTD_KEY_NUMPAD_4,
    NSTD_KEY_NUMPAD_5,
    NSTD_KEY_NUMPAD_6,
    NSTD_KEY_NUMPAD_7,
    NSTD_KEY_NUMPAD_8,
    NSTD_KEY_NUMPAD_9,
    NSTD_KEY_NUMPAD_ADD,
    NSTD_KEY_NUMPAD_DIVIDE,
    NSTD_KEY_NUMPAD_DECIMAL,
    NSTD_KEY_NUMPAD_COMMA,
    NSTD_KEY_NUMPAD_ENTER,
    NSTD_KEY_NUMPAD_EQUALS,
    NSTD_KEY_NUMPAD_MULTIPLY,
    NSTD_KEY_NUMPAD_SUBTRACT,
    NSTD_KEY_ABNTC1,
    NSTD_KEY_ABNTC2,
    NSTD_KEY_APOSTROPHE,
    NSTD_KEY_APPS,
    NSTD_KEY_ASTERISK,
    NSTD_KEY_AT,
    NSTD_KEY_AX,
    NSTD_KEY_BACKSLASH,
    NSTD_KEY_CALCULATOR,
    NSTD_KEY_CAPITAL,
    NSTD_KEY_COLON,
    NSTD_KEY_COMMA,
    NSTD_KEY_CONVERT,
    NSTD_KEY_EQUALS,
    NSTD_KEY_GRAVE,
    NSTD_KEY_KANA,
    NSTD_KEY_KANJI,
    NSTD_KEY_LEFT_ALT,
    NSTD_KEY_LEFT_BRACKET,
    NSTD_KEY_LEFT_CONTROL,
    NSTD_KEY_LEFT_SHIFT,
    NSTD_KEY_LEFT_WIN,
    NSTD_KEY_MAIL,
    NSTD_KEY_MEDIA_SELECT,
    NSTD_KEY_MEDIA_STOP,
    NSTD_KEY_MINUS,
    NSTD_KEY_MUTE,
    NSTD_KEY_MY_COMPUTER,
    NSTD_KEY_NAVIGATE_FORWARD,
    NSTD_KEY_NAVIGATE_BACKWARD,
    NSTD_KEY_NEXT_TRACK,
    NSTD_KEY_NO_CONVERT,
    NSTD_KEY_OEM102,
    NSTD_KEY_PERIOD,
    NSTD_KEY_PLAY_PAUSE,
    NSTD_KEY_PLUS,
    NSTD_KEY_POWER,
    NSTD_KEY_PREV_TRACK,
    NSTD_KEY_RIGHT_ALT,
    NSTD_KEY_RIGHT_BRACKET,
    NSTD_KEY_RIGHT_CONTROL,
    NSTD_KEY_RIGHT_SHIFT,
    NSTD_KEY_RIGHT_WIN,
    NSTD_KEY_SEMICOLON,
    NSTD_KEY_SLASH,
    NSTD_KEY_SLEEP,
    NSTD_KEY_STOP,
    NSTD_KEY_SYSRQ,
    NSTD_KEY_TAB,
    NSTD_KEY_UNDERLINE,
    NSTD_KEY_UNLABELED,
    NSTD_KEY_VOLUME_DOWN,
    NSTD_KEY_VOLUME_UP,
    NSTD_KEY_WAKE,
    NSTD_KEY_WEB_BACK,
    NSTD_KEY_WEB_FAVORITES,
    NSTD_KEY_WEB_FORWARD,
    NSTD_KEY_WEB_HOME,
    NSTD_KEY_WEB_REFRESH,
    NSTD_KEY_WEB_SEARCH,
    NSTD_KEY_WEB_STOP,
    NSTD_KEY_YEN,
    NSTD_KEY_COPY,
    NSTD_KEY_PASTE,
    NSTD_KEY_CUT
} NSTDKey;

/// Represents a key state.
typedef enum
{
    NSTD_KEY_STATE_PRESSED,
    NSTD_KEY_STATE_RELEASED
} NSTDKeyState;

/// Represents a key event.
typedef struct
{
    NSTDKey key;
    NSTDKeyState state;
    NSTDUInt32 scan_code;
} NSTDKeyEvent;

#endif
