#ifndef NSTD_CORE_INT_TYPES_H_INCLUDED
#define NSTD_CORE_INT_TYPES_H_INCLUDED
#include "def.h"
#ifdef __cplusplus
extern "C"
{
#endif

/// Gets the lowest number representable by `NSTDUInt8`.
/// Returns: `NSTDUInt8 min` - The lowest number representable by `NSTDUInt8`.
NSTDAPI NSTDUInt8 nstd_core_int_types_u8_min();
/// Gets the highest number representable by `NSTDUInt8`.
/// Returns: `NSTDUInt8 max` - The highest number representable by `NSTDUInt8`.
NSTDAPI NSTDUInt8 nstd_core_int_types_u8_max();
/// Gets the lowest number representable by `NSTDInt8`.
/// Returns: `NSTDInt8 min` - The lowest number representable by `NSTDInt8`.
NSTDAPI NSTDInt8 nstd_core_int_types_i8_min();
/// Gets the highest number representable by `NSTDInt8`.
/// Returns: `NSTDInt8 max` - The highest number representable by `NSTDInt8`.
NSTDAPI NSTDInt8 nstd_core_int_types_i8_max();

/// Gets the lowest number representable by `NSTDUInt16`.
/// Returns: `NSTDUInt16 min` - The lowest number representable by `NSTDUInt16`.
NSTDAPI NSTDUInt16 nstd_core_int_types_u16_min();
/// Gets the highest number representable by `NSTDUInt16`.
/// Returns: `NSTDUInt16 max` - The highest number representable by `NSTDUInt16`.
NSTDAPI NSTDUInt16 nstd_core_int_types_u16_max();
/// Gets the lowest number representable by `NSTDInt16`.
/// Returns: `NSTDInt16 min` - The lowest number representable by `NSTDInt16`.
NSTDAPI NSTDInt16 nstd_core_int_types_i16_min();
/// Gets the highest number representable by `NSTDInt16`.
/// Returns: `NSTDInt16 max` - The highest number representable by `NSTDInt16`.
NSTDAPI NSTDInt16 nstd_core_int_types_i16_max();

/// Gets the lowest number representable by `NSTDUInt32`.
/// Returns: `NSTDUInt32 min` - The lowest number representable by `NSTDUInt32`.
NSTDAPI NSTDUInt32 nstd_core_int_types_u32_min();
/// Gets the highest number representable by `NSTDUInt32`.
/// Returns: `NSTDUInt32 max` - The highest number representable by `NSTDUInt32`.
NSTDAPI NSTDUInt32 nstd_core_int_types_u32_max();
/// Gets the lowest number representable by `NSTDInt32`.
/// Returns: `NSTDInt32 min` - The lowest number representable by `NSTDInt32`.
NSTDAPI NSTDInt32 nstd_core_int_types_i32_min();
/// Gets the highest number representable by `NSTDInt32`.
/// Returns: `NSTDInt32 max` - The highest number representable by `NSTDInt32`.
NSTDAPI NSTDInt32 nstd_core_int_types_i32_max();

/// Gets the lowest number representable by `NSTDUInt64`.
/// Returns: `NSTDUInt64 min` - The lowest number representable by `NSTDUInt64`.
NSTDAPI NSTDUInt64 nstd_core_int_types_u64_min();
/// Gets the highest number representable by `NSTDUInt64`.
/// Returns: `NSTDUInt64 max` - The highest number representable by `NSTDUInt64`.
NSTDAPI NSTDUInt64 nstd_core_int_types_u64_max();
/// Gets the lowest number representable by `NSTDInt64`.
/// Returns: `NSTDInt64 min` - The lowest number representable by `NSTDInt64`.
NSTDAPI NSTDInt64 nstd_core_int_types_i64_min();
/// Gets the highest number representable by `NSTDInt64`.
/// Returns: `NSTDInt64 max` - The highest number representable by `NSTDInt64`.
NSTDAPI NSTDInt64 nstd_core_int_types_i64_max();

/// Gets the lowest number representable by `NSTDUSize`.
/// Returns: `NSTDUSize min` - The lowest number representable by `NSTDUSize`.
NSTDAPI NSTDUSize nstd_core_int_types_usize_min();
/// Gets the highest number representable by `NSTDUSize`.
/// Returns: `NSTDUSize max` - The highest number representable by `NSTDUSize`.
NSTDAPI NSTDUSize nstd_core_int_types_usize_max();
/// Gets the lowest number representable by `NSTDISize`.
/// Returns: `NSTDISize min` - The lowest number representable by `NSTDISize`.
NSTDAPI NSTDISize nstd_core_int_types_isize_min();
/// Gets the highest number representable by `NSTDISize`.
/// Returns: `NSTDISize max` - The highest number representable by `NSTDISize`.
NSTDAPI NSTDISize nstd_core_int_types_isize_max();

#ifdef __cplusplus
}
#endif
#endif
